/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.muxins;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.muxins.AnnotationChecker;
import org.adde0109.pcf.lib.taterapi.util.TextUtil;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.service.MixinService;

public final class Muxins {
    public static final Logger logger = Logger.create("muxins");

    private Muxins() {
    }

    public static boolean shouldApplyMixin(String mixinClassName, Collection<String> disabledMixins, boolean verbose) {
        boolean result;
        block6: {
            result = true;
            for (String disabledMixin : disabledMixins) {
                if (!mixinClassName.endsWith(disabledMixin)) continue;
                if (verbose) {
                    logger.info(TextUtil.ansiParser(Muxins.jvmdowngrader$concat$shouldApplyMixin$1(mixinClassName)));
                }
                result = false;
            }
            try {
                ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName);
                if (classNode.visibleAnnotations != null) {
                    result = AnnotationChecker.checkAnnotations(classNode.visibleAnnotations, mixinClassName, verbose);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                if (!verbose) break block6;
                logger.error(Muxins.jvmdowngrader$concat$shouldApplyMixin$2(mixinClassName), e);
            }
        }
        if (result && verbose) {
            logger.info(TextUtil.ansiParser(Muxins.jvmdowngrader$concat$shouldApplyMixin$3(mixinClassName)));
        }
        return result;
    }

    public static boolean shouldApplyMixin(String mixinClassName) {
        return Muxins.shouldApplyMixin(mixinClassName, Collections.emptyList(), false);
    }

    public static boolean shouldApplyMixin(String mixinClassName, boolean verbose) {
        return Muxins.shouldApplyMixin(mixinClassName, Collections.emptyList(), verbose);
    }

    public static boolean shouldApplyMixin(String mixinClassName, Collection<String> disabledMixins) {
        return Muxins.shouldApplyMixin(mixinClassName, disabledMixins, false);
    }

    private static String jvmdowngrader$concat$shouldApplyMixin$1(String string) {
        return "\u00a74Skipping mixin \u00a79" + string + " \u00a74disabled in config";
    }

    private static String jvmdowngrader$concat$shouldApplyMixin$2(String string) {
        return "Failed to load mixin class: " + string;
    }

    private static String jvmdowngrader$concat$shouldApplyMixin$3(String string) {
        return "\u00a72Applying mixin \u00a79" + string;
    }
}

