/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.util;

import java.util.Arrays;
import java.util.Objects;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import org.adde0109.pcf.lib.taterapi.util.FlexVerComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={Range.class})
public final class VersionUtil {

    @RecordComponents(value={@RecordComponents.Value(name="startInclusive", type=boolean.class), @RecordComponents.Value(name="start", type=String.class), @RecordComponents.Value(name="end", type=String.class), @RecordComponents.Value(name="endInclusive", type=boolean.class)})
    @NestHost(value=VersionUtil.class)
    public static final class Range
    extends J_L_Record {
        private final boolean startInclusive;
        @Nullable
        private final String start;
        @Nullable
        private final String end;
        private final boolean endInclusive;

        public Range(boolean startInclusive, @Nullable String start, @Nullable String end, boolean endInclusive) {
            this.startInclusive = startInclusive;
            this.start = start;
            this.end = end;
            this.endInclusive = endInclusive;
        }

        @Nullable
        public static Range parse(@NotNull String rangeString) {
            String end;
            String start;
            boolean endInclusive;
            boolean startInclusive;
            Objects.requireNonNull(rangeString, "Range string cannot be null");
            rangeString = rangeString.trim();
            if (rangeString.startsWith("[")) {
                startInclusive = true;
            } else if (rangeString.startsWith("(")) {
                startInclusive = false;
            } else {
                return null;
            }
            if (rangeString.endsWith("]")) {
                endInclusive = true;
            } else if (rangeString.endsWith(")")) {
                endInclusive = false;
            } else {
                return null;
            }
            rangeString = rangeString.substring(1, rangeString.length() - 1);
            if (rangeString.startsWith(",")) {
                start = null;
                end = rangeString.substring(1);
            } else if (rangeString.endsWith(",")) {
                start = rangeString.substring(0, rangeString.length() - 1);
                end = null;
            } else {
                String[] split = rangeString.split(",");
                if (split.length != 2) {
                    return null;
                }
                start = split[0];
                end = split[1];
            }
            return new Range(startInclusive, start, end, endInclusive);
        }

        public boolean resolve(@NotNull String version) {
            Objects.requireNonNull(version, "version cannot be null");
            Objects.requireNonNull(this.start, "start cannot be null");
            Objects.requireNonNull(this.end, "end cannot be null");
            return (this.startInclusive ? FlexVerComparator.compare(version, this.start) >= 0 : FlexVerComparator.compare(version, this.start) > 0) && (this.endInclusive ? FlexVerComparator.compare(version, this.end) <= 0 : FlexVerComparator.compare(version, this.end) < 0);
        }

        @Override
        public final String toString() {
            return Range.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return Range.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return Range.jvmdowngrader$equals$equals(this, o);
        }

        public boolean startInclusive() {
            return this.startInclusive;
        }

        @Nullable
        public String start() {
            return this.start;
        }

        @Nullable
        public String end() {
            return this.end;
        }

        public boolean endInclusive() {
            return this.endInclusive;
        }

        private static String jvmdowngrader$toString$toString(Range range) {
            Range range2 = range;
            return "VersionUtil$Range[" + "startInclusive=" + range.startInclusive + ", " + "start=" + range.start + ", " + "end=" + range.end + ", " + "endInclusive=" + range.endInclusive + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(Range range) {
            Object[] objectArray = new Object[]{range.startInclusive, range.start, range.end, range.endInclusive};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(Range range, Object object) {
            if (range == object) {
                return true;
            }
            if (object != null && object instanceof Range) {
                Range range2 = (Range)object;
                if (range.startInclusive == range2.startInclusive && Objects.equals(range.start, range2.start) && Objects.equals(range.end, range2.end) && range.endInclusive == range2.endInclusive) {
                    return true;
                }
            }
            return false;
        }
    }
}

