/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.v1_14_4.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.adde0109.pcf.PCF;
import org.adde0109.pcf.forwarding.Mode;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Config {
    private static final Config config;
    public static final ForgeConfigSpec spec;
    private final ForgeConfigSpec.ConfigValue<Double> version;
    private final ForgeConfigSpec.ConfigValue<Boolean> enableForwarding;
    private final ForgeConfigSpec.ConfigValue<Mode> forwardingMode;
    private final ForgeConfigSpec.ConfigValue<String> forwardingSecret;
    private final ForgeConfigSpec.ConfigValue<Boolean> enableCrossStitch;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> forceWrappedArguments;
    private final ForgeConfigSpec.ConfigValue<Boolean> forceWrapVanillaArguments;
    private final ForgeConfigSpec.ConfigValue<Boolean> enableDebug;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledMixins;

    Config(ForgeConfigSpec.Builder builder) {
        this.version = builder.comment("Config version, DO NOT CHANGE THIS").define("version", (Object)2.0);
        builder.comment("Player Info Forwarding Settings").push("forwarding");
        this.enableForwarding = builder.comment("Enable or disable player info forwarding. Changing this setting requires a server restart.").define("enabled", true);
        this.forwardingMode = builder.comment("The type of forwarding to use").defineEnum("mode", (Enum)Mode.MODERN);
        this.forwardingSecret = builder.comment("The forwarding secret shared with the proxy").define("secret", (Object)"");
        builder.pop();
        builder.comment("CrossStitch Settings - For Wrapping Modded Command Arguments").push("crossStitch");
        this.enableCrossStitch = builder.comment("Enable or disable CrossStitch support. Changing this setting requires a server restart.").define("enabled", true);
        this.forceWrappedArguments = builder.comment("Add any incompatible modded or vanilla command argument types here").defineList("forceWrappedArguments", J_U_List.of(), obj -> true);
        this.forceWrapVanillaArguments = builder.comment("Force wrap vanilla command argument types. Useful for when the above setting gets a bit excessive.").define("forceWrapVanillaArguments", false);
        builder.pop();
        builder.comment("Debug Settings").push("debug");
        this.enableDebug = builder.comment("Enable or disable debug mode.").define("enabled", false);
        this.disabledMixins = builder.comment("List of mixins to disable. Use the Mixin's name and prefix it with it's partial or full package name.").defineList("disabledMixins", J_U_List.of(), obj -> true);
        builder.pop();
    }

    public static void reload() {
        String forwardingSecret = (String)Config.config.forwardingSecret.get();
        PCF.instance().setForwarding(new PCF.Forwarding((Boolean)Config.config.enableForwarding.get() != false && !J_L_String.isBlank(forwardingSecret), (Mode)((Object)Config.config.forwardingMode.get()), forwardingSecret));
        PCF.instance().setCrossStitch(new PCF.CrossStitch((Boolean)Config.config.enableCrossStitch.get(), (List)Config.config.forceWrappedArguments.get(), (Boolean)Config.config.forceWrapVanillaArguments.get()));
        PCF.instance().setDebug(new PCF.Debug((Boolean)Config.config.enableDebug.get(), (List)Config.config.disabledMixins.get()));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        spec = (ForgeConfigSpec)specPair.getRight();
        config = (Config)specPair.getLeft();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("proxy-compatible-forge.toml")).sync().preserveInsertionOrder().onFileNotFound((file, configFormat) -> {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Path p = FMLPaths.CONFIGDIR.get().resolve("proxy-compatible-forge.toml");
            if (Files.exists(p, new LinkOption[0])) {
                Files.copy(p, file, new CopyOption[0]);
            } else {
                Files.createFile(file, new FileAttribute[0]);
                configFormat.initEmptyFile(file);
            }
            return true;
        }).autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        spec.correct((CommentedConfig)config);
        spec.setConfig((CommentedConfig)config);
    }
}

