/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.common;

import com.google.common.collect.ImmutableMultimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.adde0109.pcf.PCF;
import org.adde0109.pcf.common.abstractions.Connection;
import org.adde0109.pcf.common.abstractions.Payload;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.jetbrains.annotations.NotNull;

public final class ModernForwarding {
    public static final int QUERY_ID = 1203961429;
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    private static final boolean isAtLeast21_9 = MetaAPI.instance().version().isAtLeast(MinecraftVersions.V21_9);
    private static Method propertiesMethod;

    private ModernForwarding() {
    }

    public static boolean validate(Payload buffer) {
        byte[] signature = new byte[32];
        buffer.readBytes(signature);
        byte[] data = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(PCF.instance().forwarding().secret().getBytes(), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    @NotNull
    public static GameProfile handleForwardingPacket(Payload data, Connection conn) throws Exception {
        GameProfile profile;
        if (!ModernForwarding.validate(data)) {
            throw new Exception("Player-data could not be validated!");
        }
        PCF.logger.debug("Player-data validated!");
        int version = data.readVarInt();
        if (version != 1) {
            throw new IllegalStateException(ModernForwarding.jvmdowngrader$concat$handleForwardingPacket$1(version));
        }
        String ip = data.readUtf();
        conn.setAddress(new InetSocketAddress(ip, ((InetSocketAddress)conn.remoteAddress()).getPort()));
        if (isAtLeast21_9) {
            profile = new GameProfile(data.readUUID(), data.readUtf(16), new PropertyMap(ModernForwarding.readProperties(data)));
        } else {
            profile = new GameProfile(data.readUUID(), data.readUtf(16));
            ImmutableMultimap<String, Property> properties = ModernForwarding.readProperties(data);
            if (propertiesMethod == null) {
                propertiesMethod = GameProfile.class.getMethod("getProperties", new Class[0]);
            }
            PropertyMap propertiesMap = (PropertyMap)propertiesMethod.invoke((Object)profile, new Object[0]);
            propertiesMap.putAll(properties);
        }
        return profile;
    }

    public static ImmutableMultimap<String, Property> readProperties(Payload buf) {
        ImmutableMultimap.Builder propertiesBuilder = ImmutableMultimap.builder();
        int size = buf.readVarInt();
        for (int i = 0; i < size; ++i) {
            String name = buf.readUtf();
            String value = buf.readUtf();
            String signature = "";
            boolean hasSignature = buf.readBoolean();
            if (hasSignature) {
                signature = buf.readUtf();
            }
            propertiesBuilder.put((Object)name, (Object)new Property(name, value, signature));
        }
        return propertiesBuilder.build();
    }

    private static String jvmdowngrader$concat$handleForwardingPacket$1(int n) {
        return "Unsupported forwarding version " + n + ", wanted 1";
    }
}

