/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.common.reflection;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_I_MethodHandles;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.Platform;

public class StateUtil {
    private static final VarHandle cachedStateField;
    private static final Enum<?>[] cachedStateEnumConstants;

    public static Object getState(Object slpl) {
        return cachedStateField.get(slpl);
    }

    public static void setState(Object slpl, int ord) {
        Enum<?> state = cachedStateEnumConstants[ord];
        cachedStateField.set(slpl, state);
    }

    public static boolean stateEquals(Object slpl, int ord) {
        Object e = StateUtil.getState(slpl);
        return ((Enum)e).ordinal() == ord;
    }

    static {
        MinecraftVersion mcv = MetaAPI.instance().version();
        Platform p = MetaAPI.instance().platform();
        String slplClassName = "net.minecraft.server.network.ServerLoginPacketListenerImpl";
        String stateFieldName = "state";
        if (mcv.isInRange(MinecraftVersions.V14_4, MinecraftVersions.V16_5)) {
            stateFieldName = "field_147328_g";
            slplClassName = "net.minecraft.network.login.ServerLoginNetHandler";
        } else if (mcv.isInRange(MinecraftVersions.V17, MinecraftVersions.V20_4) && p.isForge() && !p.isNeoForge()) {
            stateFieldName = "f_10019_";
        }
        String slplStateClassName = StateUtil.jvmdowngrader$concat$$clinit$$1(slplClassName);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> slplClass = Class.forName(slplClassName);
            Field stateField = slplClass.getDeclaredField(stateFieldName);
            stateField.setAccessible(true);
            MethodHandles.Lookup privLookup = J_L_I_MethodHandles.privateLookupIn(slplClass, lookup);
            cachedStateField = privLookup.unreflectVarHandle(stateField);
            Class<?> cachedStateClass = Class.forName(slplStateClassName);
            cachedStateEnumConstants = (Enum[])cachedStateClass.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static String jvmdowngrader$concat$$clinit$$1(String string) {
        return string + "$State";
    }
}

