/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.event;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.adde0109.pcf.lib.taterapi.event.Event;

public class EventManager<T extends Event> {
    private final Class<T> eventClass;
    private final ArrayList<Consumer<T>> listeners = new ArrayList();

    public EventManager(Class<T> eventClass, Consumer<T> listener) {
        this.eventClass = eventClass;
        this.listeners.add(listener);
    }

    public EventManager(Class<T> eventClass) {
        this.eventClass = eventClass;
    }

    public Class<T> eventClass() {
        return this.eventClass;
    }

    public void register(Consumer<T> listener) {
        this.listeners.add(listener);
    }

    public ArrayList<Consumer<T>> listeners() {
        return this.listeners;
    }

    public void invoke(T event) {
        for (Consumer<T> listener : this.listeners) {
            listener.accept(event);
        }
    }
}

