/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.meta.Mappings;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.anno.AConstraint;
import org.adde0109.pcf.lib.taterapi.meta.anno.Dependency;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;
import xyz.wagyourtail.jvmdg.version.Stub;

@RecordComponents(value={@RecordComponents.Value(name="deps", type=Set.class), @RecordComponents.Value(name="notDeps", type=Set.class), @RecordComponents.Value(name="mappings", type=Mappings.class), @RecordComponents.Value(name="platform", type=Set.class), @RecordComponents.Value(name="notPlatform", type=Set.class), @RecordComponents.Value(name="side", type=Set.class), @RecordComponents.Value(name="version", type=Set.class), @RecordComponents.Value(name="min", type=MinecraftVersion.class), @RecordComponents.Value(name="max", type=MinecraftVersion.class), @RecordComponents.Value(name="notVersion", type=Set.class), @RecordComponents.Value(name="notMin", type=MinecraftVersion.class), @RecordComponents.Value(name="notMax", type=MinecraftVersion.class)})
@NestMembers(value={Evaluator.class, Builder.class})
public final class Constraint
extends J_L_Record {
    private final Set<String> deps;
    private final Set<String> notDeps;
    private final Mappings mappings;
    private final Set<Platform> platform;
    private final Set<Platform> notPlatform;
    private final Set<Side> side;
    private final Set<MinecraftVersion> version;
    private final MinecraftVersion min;
    private final MinecraftVersion max;
    private final Set<MinecraftVersion> notVersion;
    private final MinecraftVersion notMin;
    private final MinecraftVersion notMax;

    public Constraint(Set<String> deps, Set<String> notDeps, Mappings mappings, Set<Platform> platform, Set<Platform> notPlatform, Set<Side> side, Set<MinecraftVersion> version, MinecraftVersion min, MinecraftVersion max, Set<MinecraftVersion> notVersion, MinecraftVersion notMin, MinecraftVersion notMax) {
        this.deps = deps;
        this.notDeps = notDeps;
        this.mappings = mappings;
        this.platform = platform;
        this.notPlatform = notPlatform;
        this.side = side;
        this.version = version;
        this.min = min;
        this.max = max;
        this.notVersion = notVersion;
        this.notMin = notMin;
        this.notMax = notMax;
    }

    public boolean result() {
        return Evaluator.evaluate(this);
    }

    public static Constraint from(AConstraint constraint) {
        return Constraint.builder().deps(J_U_S_Stream.toList(Stream.of(constraint.deps()).map(Dependency::value))).notDeps(J_U_S_Stream.toList(Stream.of(constraint.notDeps()).map(Dependency::value))).mappings(constraint.mappings()).platform(J_U_S_Stream.toList(Stream.of(constraint.platform()).map(org.adde0109.pcf.lib.taterapi.meta.enums.Platform::ref))).notPlatform(J_U_S_Stream.toList(Stream.of(constraint.notPlatform()).map(org.adde0109.pcf.lib.taterapi.meta.enums.Platform::ref))).side(J_U_S_Stream.toList(Stream.of(constraint.side()))).version(J_U_S_Stream.toList(Stream.of(constraint.version().value()).map(org.adde0109.pcf.lib.taterapi.meta.enums.MinecraftVersion::ref))).min(constraint.version().min().ref()).max(constraint.version().max().ref()).notVersion(J_U_S_Stream.toList(Stream.of(constraint.notVersion().value()).map(org.adde0109.pcf.lib.taterapi.meta.enums.MinecraftVersion::ref))).notMin(constraint.notVersion().min().ref()).notMax(constraint.notVersion().max().ref()).build();
    }

    @Override
    @NotNull
    public String toString() {
        return Constraint.jvmdowngrader$concat$toString$1(String.valueOf(this.deps), String.valueOf(this.notDeps), String.valueOf((Object)this.mappings), String.valueOf(this.platform), String.valueOf(this.notPlatform), String.valueOf(this.side), String.valueOf(this.version), String.valueOf(this.min), String.valueOf(this.max), String.valueOf(this.notVersion), String.valueOf(this.notMin), String.valueOf(this.notMax));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final int hashCode() {
        return Constraint.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return Constraint.jvmdowngrader$equals$equals(this, o);
    }

    public Set<String> deps() {
        return this.deps;
    }

    public Set<String> notDeps() {
        return this.notDeps;
    }

    public Mappings mappings() {
        return this.mappings;
    }

    public Set<Platform> platform() {
        return this.platform;
    }

    public Set<Platform> notPlatform() {
        return this.notPlatform;
    }

    public Set<Side> side() {
        return this.side;
    }

    public Set<MinecraftVersion> version() {
        return this.version;
    }

    public MinecraftVersion min() {
        return this.min;
    }

    public MinecraftVersion max() {
        return this.max;
    }

    public Set<MinecraftVersion> notVersion() {
        return this.notVersion;
    }

    public MinecraftVersion notMin() {
        return this.notMin;
    }

    public MinecraftVersion notMax() {
        return this.notMax;
    }

    private static int jvmdowngrader$hashCode$hashCode(Constraint constraint) {
        Object[] objectArray = new Object[]{constraint.deps, constraint.notDeps, constraint.mappings, constraint.platform, constraint.notPlatform, constraint.side, constraint.version, constraint.min, constraint.max, constraint.notVersion, constraint.notMin, constraint.notMax};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(Constraint constraint, Object object) {
        if (constraint == object) {
            return true;
        }
        if (object != null && object instanceof Constraint) {
            Constraint constraint2 = (Constraint)object;
            if (Objects.equals(constraint.deps, constraint2.deps) && Objects.equals(constraint.notDeps, constraint2.notDeps) && Objects.equals((Object)constraint.mappings, (Object)constraint2.mappings) && Objects.equals(constraint.platform, constraint2.platform) && Objects.equals(constraint.notPlatform, constraint2.notPlatform) && Objects.equals(constraint.side, constraint2.side) && Objects.equals(constraint.version, constraint2.version) && Objects.equals(constraint.min, constraint2.min) && Objects.equals(constraint.max, constraint2.max) && Objects.equals(constraint.notVersion, constraint2.notVersion) && Objects.equals(constraint.notMin, constraint2.notMin) && Objects.equals(constraint.notMax, constraint2.notMax)) {
                return true;
            }
        }
        return false;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notPlatform() {
        return this.notPlatform;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$notPlatform(Set set) {
        this.notPlatform = set;
    }

    Mappings jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$mappings() {
        return this.mappings;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$mappings(Mappings mappings) {
        this.mappings = mappings;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$side() {
        return this.side;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$side(Set set) {
        this.side = set;
    }

    MinecraftVersion jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$min() {
        return this.min;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$min(MinecraftVersion minecraftVersion) {
        this.min = minecraftVersion;
    }

    MinecraftVersion jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$max() {
        return this.max;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$max(MinecraftVersion minecraftVersion) {
        this.max = minecraftVersion;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notVersion() {
        return this.notVersion;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$notVersion(Set set) {
        this.notVersion = set;
    }

    MinecraftVersion jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMax() {
        return this.notMax;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$notMax(MinecraftVersion minecraftVersion) {
        this.notMax = minecraftVersion;
    }

    MinecraftVersion jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMin() {
        return this.notMin;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$notMin(MinecraftVersion minecraftVersion) {
        this.notMin = minecraftVersion;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$deps() {
        return this.deps;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$deps(Set set) {
        this.deps = set;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notDeps() {
        return this.notDeps;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$notDeps(Set set) {
        this.notDeps = set;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$version() {
        return this.version;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$version(Set set) {
        this.version = set;
    }

    Set jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$platform() {
        return this.platform;
    }

    void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$set$platform(Set set) {
        this.platform = set;
    }

    private static String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        return "Constraint{deps=" + string + ", notDeps=" + string2 + ", mappings=" + string3 + ", platform=" + string4 + ", notPlatform=" + string5 + ", side=" + string6 + ", version=" + string7 + ", min=" + string8 + ", max=" + string9 + ", notVersion=" + string10 + ", notMin=" + string11 + ", notMax=" + string12 + "}";
    }

    @NestHost(value=Constraint.class)
    public static final class Evaluator {
        private static final Map<Constraint, Boolean> CACHE = new WeakHashMap<Constraint, Boolean>();
        private static final MetaAPI META = MetaAPI.instance();
        private static final Mappings MAPPINGS = META.mappings();
        private static final MinecraftVersion version = META.version();
        public static boolean DEBUG = false;
        private static final Logger logger = Logger.create("taterliblite-meta-constraint");

        private Evaluator() {
        }

        public static boolean evalDeps(Constraint constraint) {
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$deps().isEmpty() && !META.isModLoaded((String[])Evaluator.jvmdg$inlined$toArray(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$deps(), String[]::new))) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalDeps$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$deps())));
                }
                return false;
            }
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notDeps().isEmpty() && META.isModLoaded((String[])Evaluator.jvmdg$inlined$toArray(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notDeps(), String[]::new))) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalDeps$2(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notDeps())));
                }
                return false;
            }
            if (DEBUG) {
                logger.debug("Dependency constraint passed.");
            }
            return true;
        }

        public static boolean evalMappings(Constraint constraint) {
            if (constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$mappings() == Mappings.NONE) {
                return true;
            }
            if (MAPPINGS != constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$mappings()) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalMappings$1(String.valueOf((Object)constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$mappings()), String.valueOf((Object)MAPPINGS)));
                }
                return false;
            }
            if (DEBUG) {
                logger.debug(Evaluator.jvmdowngrader$concat$evalMappings$2(String.valueOf((Object)constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$mappings()), String.valueOf((Object)MAPPINGS)));
            }
            return true;
        }

        public static boolean evalPlatform(Constraint constraint) {
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$platform().isEmpty() && !META.isPlatformPresent((Platform[])Evaluator.jvmdg$inlined$toArray(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$platform(), Platform[]::new))) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalPlatform$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$platform())));
                }
                return false;
            }
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notPlatform().isEmpty() && META.isPlatformPresent((Platform[])Evaluator.jvmdg$inlined$toArray(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$platform(), Platform[]::new))) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalPlatform$2(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notPlatform())));
                }
                return false;
            }
            if (DEBUG) {
                logger.debug(Evaluator.jvmdowngrader$concat$evalPlatform$3(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$platform())));
            }
            return true;
        }

        public static boolean evalSide(Constraint constraint) {
            if (constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$side().isEmpty()) {
                return true;
            }
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$side().contains((Object)META.side())) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalSide$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$side())));
                }
                return false;
            }
            if (DEBUG) {
                logger.debug(Evaluator.jvmdowngrader$concat$evalSide$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$side()), String.valueOf((Object)META.side())));
            }
            return true;
        }

        public static boolean evalVersion(Constraint constraint) {
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$version().isEmpty() && !constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$version().contains(version)) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalVersion$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$version()), String.valueOf(version)));
                }
                return false;
            }
            if (constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$min() != MinecraftVersions.UNKNOWN && constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$max() != MinecraftVersions.UNKNOWN && !version.isInRange(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$min(), constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$max())) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalVersion$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$min()), String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$max()), String.valueOf(version)));
                }
                return false;
            }
            if (!constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notVersion().isEmpty() && constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notVersion().contains(version)) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalVersion$2(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notVersion()), String.valueOf(version)));
                }
                return false;
            }
            if (constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMin() != MinecraftVersions.UNKNOWN && constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMax() != MinecraftVersions.UNKNOWN && version.isInRange(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMin(), constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMax())) {
                if (DEBUG) {
                    logger.debug(Evaluator.jvmdowngrader$concat$evalVersion$2(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMin()), String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$notMax()), String.valueOf(version)));
                }
                return false;
            }
            if (DEBUG) {
                logger.debug(Evaluator.jvmdowngrader$concat$evalVersion$1(String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$version()), String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$min()), String.valueOf(constraint.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_meta_Constraint$get$max()), String.valueOf(version)));
            }
            return true;
        }

        public static boolean evaluate(Constraint constraint) {
            if (CACHE.containsKey(constraint)) {
                return CACHE.get(constraint);
            }
            if (DEBUG) {
                logger.debug(Evaluator.jvmdowngrader$concat$evaluate$1(String.valueOf(constraint)));
            }
            boolean result = Evaluator.evalDeps(constraint) && Evaluator.evalMappings(constraint) && Evaluator.evalPlatform(constraint) && Evaluator.evalSide(constraint) && Evaluator.evalVersion(constraint);
            CACHE.put(constraint, result);
            return result;
        }

        private static String jvmdowngrader$concat$evalDeps$1(String string) {
            return "Dependency constraint failed. Required deps not found: " + string;
        }

        private static String jvmdowngrader$concat$evalDeps$2(String string) {
            return "Dependency constraint failed. Forbidden deps found: " + string;
        }

        private static String jvmdowngrader$concat$evalMappings$1(String string, String string2) {
            return "Mappings constraint failed. Required: " + string + ", Found: " + string2;
        }

        private static String jvmdowngrader$concat$evalMappings$2(String string, String string2) {
            return "Mappings constraint passed. Expected: " + string + ", Found: " + string2;
        }

        private static String jvmdowngrader$concat$evalPlatform$1(String string) {
            return "Platform constraint failed. Required platforms not found: " + string;
        }

        private static String jvmdowngrader$concat$evalPlatform$2(String string) {
            return "Platform constraint failed. Forbidden platforms found: " + string;
        }

        private static String jvmdowngrader$concat$evalPlatform$3(String string) {
            return "Platform constraint passed. Expected: " + string;
        }

        private static String jvmdowngrader$concat$evalSide$1(String string) {
            return "Side constraint failed. Required sides not found: " + string;
        }

        private static String jvmdowngrader$concat$evalSide$1(String string, String string2) {
            return "Side constraint passed. Expected: " + string + ", Found: " + string2;
        }

        private static String jvmdowngrader$concat$evalVersion$1(String string, String string2) {
            return "Version constraint failed. Required versions not found: " + string + ", Found: " + string2;
        }

        private static String jvmdowngrader$concat$evalVersion$1(String string, String string2, String string3) {
            return "Version constraint failed. Required range not satisfied: " + string + " - " + string2 + ", Found: " + string3;
        }

        private static String jvmdowngrader$concat$evalVersion$2(String string, String string2) {
            return "Version constraint failed. Forbidden versions found: " + string + ", Found: " + string2;
        }

        private static String jvmdowngrader$concat$evalVersion$2(String string, String string2, String string3) {
            return "Version constraint failed. Forbidden range satisfied: " + string + " - " + string2 + ", Found: " + string3;
        }

        private static String jvmdowngrader$concat$evalVersion$1(String string, String string2, String string3, String string4) {
            return "Version constraint passed. Expected: " + string + ", " + string2 + "-" + string3 + ", Found: " + string4;
        }

        private static String jvmdowngrader$concat$evaluate$1(String string) {
            return "Evaluating constraint: " + string;
        }

        @Stub
        private static <T> T[] jvmdg$inlined$toArray(Collection<T> collection, IntFunction<T[]> generator) {
            return collection.toArray(generator.apply(0));
        }
    }

    @NestHost(value=Constraint.class)
    public static final class Builder {
        private final Set<String> deps = new HashSet<String>();
        private final Set<String> notDeps = new HashSet<String>();
        private Mappings mappings = Mappings.NONE;
        private final Set<Platform> platform = new HashSet<Platform>();
        private final Set<Platform> notPlatform = new HashSet<Platform>();
        private final Set<Side> side = new HashSet<Side>();
        private final Set<MinecraftVersion> version = new HashSet<MinecraftVersion>();
        private MinecraftVersion min = MinecraftVersions.UNKNOWN;
        private MinecraftVersion max = MinecraftVersions.UNKNOWN;
        private final Set<MinecraftVersion> notVersion = new HashSet<MinecraftVersion>();
        private MinecraftVersion notMin = MinecraftVersions.UNKNOWN;
        private MinecraftVersion notMax = MinecraftVersions.UNKNOWN;

        Builder() {
        }

        public Builder deps(Collection<String> deps) {
            this.deps.addAll(deps);
            return this;
        }

        public Builder deps(String ... deps) {
            return this.deps(J_U_List.of(deps));
        }

        public Builder notDeps(Collection<String> notDeps) {
            this.notDeps.addAll(notDeps);
            return this;
        }

        public Builder notDeps(String ... notDeps) {
            return this.notDeps(J_U_List.of(notDeps));
        }

        public Builder mappings(Mappings mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder platform(Collection<Platform> platform) {
            this.platform.addAll(platform);
            return this;
        }

        public Builder platform(Platform ... platform) {
            return this.platform(J_U_List.of(platform));
        }

        public Builder notPlatform(Collection<Platform> notPlatform) {
            this.notPlatform.addAll(notPlatform);
            return this;
        }

        public Builder notPlatform(Platform ... notPlatform) {
            return this.notPlatform(J_U_List.of(notPlatform));
        }

        public Builder side(Collection<Side> side) {
            this.side.addAll(side);
            return this;
        }

        public Builder side(Side ... side) {
            return this.side(J_U_List.of(side));
        }

        public Builder version(Collection<MinecraftVersion> version) {
            this.version.addAll(version);
            return this;
        }

        public Builder version(MinecraftVersion ... version) {
            return this.version(J_U_List.of(version));
        }

        public Builder min(MinecraftVersion min) {
            this.min = min;
            return this;
        }

        public Builder max(MinecraftVersion max) {
            this.max = max;
            return this;
        }

        public Builder notVersion(Collection<MinecraftVersion> notVersion) {
            this.notVersion.addAll(notVersion);
            return this;
        }

        public Builder notVersion(MinecraftVersion ... notVersion) {
            return this.notVersion(J_U_List.of(notVersion));
        }

        public Builder notMin(MinecraftVersion notMin) {
            this.notMin = notMin;
            return this;
        }

        public Builder notMax(MinecraftVersion notMax) {
            this.notMax = notMax;
            return this;
        }

        public Constraint build() {
            return new Constraint(Collections.unmodifiableSet(this.deps), Collections.unmodifiableSet(this.notDeps), this.mappings, Collections.unmodifiableSet(this.platform), Collections.unmodifiableSet(this.notPlatform), Collections.unmodifiableSet(this.side), Collections.unmodifiableSet(this.version), this.min, this.max, Collections.unmodifiableSet(this.notVersion), this.notMin, this.notMax);
        }
    }
}

