/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta;

import java.util.Optional;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.meta.Mappings;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.MetaAPIImpl;
import org.adde0109.pcf.lib.taterapi.util.ReflectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={NoPlatformMetaException.class, NoPrimaryPlatformException.class, RedefinePrimaryPlatformException.class, NoPlatformException.class})
public interface MetaAPI {
    public static MetaAPI instance() {
        return MetaAPIImpl.getInstance();
    }

    @NotNull
    public Platform primaryPlatform() throws NoPrimaryPlatformException;

    @ApiStatus.Internal
    public void setPrimaryPlatform(@NotNull Platform var1) throws RedefinePrimaryPlatformException;

    public boolean isPrimaryPlatform(@NotNull Platform var1) throws NoPrimaryPlatformException;

    @NotNull
    public Platform platform() throws NoPlatformException;

    public boolean isPlatformPresent(@NotNull Platform var1);

    default public boolean isPlatformPresent(Platform ... platform) {
        for (Platform p : platform) {
            if (!this.isPlatformPresent(p)) continue;
            return true;
        }
        return false;
    }

    default public boolean allPlatformsPresent(Platform ... platform) {
        for (Platform p : platform) {
            if (this.isPlatformPresent(p)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Platform.Meta meta() throws NoPlatformException, NoPlatformMetaException;

    public Optional<Platform.Meta> meta(@NotNull Platform var1);

    @NotNull
    public Object server();

    @NotNull
    public Object client();

    @NotNull
    public Object minecraft();

    @NotNull
    public Side side();

    public boolean isClient();

    @NotNull
    public MinecraftVersion version();

    public boolean isModLoaded(String ... var1);

    public boolean isModLoaded(@NotNull Platform var1, String ... var2);

    public boolean areModsLoaded(String ... var1);

    public boolean areModsLoaded(@NotNull Platform var1, String ... var2);

    @NotNull
    public Mappings mappings();

    @NotNull
    public Logger logger(@NotNull String var1);

    default public boolean isSpongeForge() {
        return this.allPlatformsPresent(Platforms.SPONGE, Platforms.FORGE);
    }

    default public boolean isSpongeFabric() {
        return this.allPlatformsPresent(Platforms.SPONGE, Platforms.FABRIC);
    }

    default public boolean isProxy() {
        return this.isPlatformPresent(Platforms.BUNGEECORD, Platforms.VELOCITY);
    }

    default public boolean isForgeHybrid() {
        return this.allPlatformsPresent(Platforms.FORGE, Platforms.BUKKIT);
    }

    default public boolean isFabricHybrid() {
        return this.allPlatformsPresent(Platforms.FABRIC, Platforms.BUKKIT);
    }

    default public boolean isNeoForgeHybrid() {
        return this.allPlatformsPresent(Platforms.NEOFORGE, Platforms.BUKKIT);
    }

    default public boolean isHybrid() {
        return this.isForgeHybrid() || this.isFabricHybrid() || this.isNeoForgeHybrid();
    }

    default public boolean isMixedForgeFabric() {
        return this.allPlatformsPresent(Platforms.FORGE, Platforms.FABRIC);
    }

    default public boolean isMixedNeoForgeFabric() {
        return this.allPlatformsPresent(Platforms.NEOFORGE, Platforms.FABRIC);
    }

    public static boolean isBukkitBased(Platform platform) {
        return platform == Platforms.BUKKIT || platform == Platforms.SPIGOT || platform == Platforms.PAPER || platform == Platforms.PURPUR || platform == Platforms.PUFFERFISH || platform == Platforms.FOLIA || platform == Platforms.POSEIDON || MetaAPI.isHybrid(platform);
    }

    public static boolean isBungeeCordBased(Platform platform) {
        return platform == Platforms.BUNGEECORD || platform == Platforms.WATERFALL || platform == Platforms.LIGHTFALL || platform == Platforms.TRAVERTINE;
    }

    public static boolean isFabricBased(Platform platform) {
        return platform == Platforms.FABRIC || platform == Platforms.QUILT || MetaAPI.isFabricHybrid(platform);
    }

    public static boolean isFabricHybrid(Platform platform) {
        return platform == Platforms.CARDBOARD || platform == Platforms.BANNER;
    }

    public static boolean isForgeBased(Platform platform) {
        return platform == Platforms.FORGE || platform == Platforms.GOLDENFORGE || MetaAPI.isForgeHybrid(platform);
    }

    public static boolean isForgeHybrid(Platform platform) {
        return platform == Platforms.MCPCPLUSPLUS || platform == Platforms.CAULDRON || platform == Platforms.KCAULDRON || platform == Platforms.THERMOS || platform == Platforms.CRUCIBLE || platform == Platforms.MOHIST || platform == Platforms.MAGMA || platform == Platforms.KETTING;
    }

    public static boolean isNeoForgeBased(Platform platform) {
        return platform == Platforms.NEOFORGE || MetaAPI.isNeoForgeHybrid(platform);
    }

    public static boolean isNeoForgeHybrid(Platform platform) {
        return platform == Platforms.YOUER;
    }

    public static boolean isHybrid(Platform platform) {
        return platform == Platforms.ARCLIGHT || MetaAPI.isForgeHybrid(platform) || MetaAPI.isFabricHybrid(platform);
    }

    default public boolean isBrigadierSupported() {
        return this.version().isAtLeast(MinecraftVersions.V13) || this.isPlatformPresent(Platforms.VELOCITY) || ReflectionUtil.checkForClass("com.mojang.brigadier.CommandDispatcher");
    }

    @NestHost(value=MetaAPI.class)
    public static final class NoPlatformMetaException
    extends IllegalStateException {
        public NoPlatformMetaException(Platform platform) {
            super(NoPlatformMetaException.jvmdowngrader$concat$$init$$1(platform.name()));
        }

        private static String jvmdowngrader$concat$$init$$1(String string) {
            return "No metadata found for platform " + string + ". This shouldn't normally happen, please file a bug report";
        }
    }

    @NestHost(value=MetaAPI.class)
    public static final class NoPrimaryPlatformException
    extends IllegalStateException {
        public NoPrimaryPlatformException() {
            super("No primary platform found, please call MetaAPIImpl#setPrimaryPlatform(Platform) to set it");
        }
    }

    @NestHost(value=MetaAPI.class)
    public static final class RedefinePrimaryPlatformException
    extends IllegalStateException {
        public RedefinePrimaryPlatformException() {
            super("The primary platform has already been set, if it's being set again, it usually indicates a platform-init-flow related issue");
        }
    }

    @NestHost(value=MetaAPI.class)
    public static final class NoPlatformException
    extends IllegalStateException {
        public NoPlatformException() {
            super("No platform found, this really shouldn't happen, unless the platform you're using hasn't been implemented in the API");
        }
    }
}

