/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.util.PathUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Meta.class})
public interface Platform {
    public String name();

    default public boolean detect() {
        return this.detect(false);
    }

    @ApiStatus.Internal
    public boolean detect(boolean var1);

    default public boolean isBukkit() {
        return this.equals(Platforms.BUKKIT) || this.isSpigot() || this.isPaper();
    }

    default public boolean isSpigot() {
        return this.equals(Platforms.SPIGOT);
    }

    default public boolean isPaper() {
        return this.equals(Platforms.PAPER);
    }

    default public boolean isBungeeCord() {
        return this.equals(Platforms.BUNGEECORD) || this.isWaterfall();
    }

    default public boolean isWaterfall() {
        return this.equals(Platforms.WATERFALL);
    }

    default public boolean isFabric() {
        return this.equals(Platforms.FABRIC) || this.isQuilt() || this.isFabricHybrid();
    }

    default public boolean isQuilt() {
        return this.equals(Platforms.QUILT);
    }

    default public boolean isFabricHybrid() {
        return this.equals(Platforms.CARDBOARD) || this.equals(Platforms.BANNER);
    }

    default public boolean isForge() {
        return this.equals(Platforms.FORGE) || this.equals(Platforms.GOLDENFORGE) || this.isForgeHybrid();
    }

    default public boolean isForgeHybrid() {
        return this.equals(Platforms.MCPCPLUSPLUS) || this.equals(Platforms.CAULDRON) || this.equals(Platforms.KCAULDRON) || this.equals(Platforms.THERMOS) || this.equals(Platforms.CRUCIBLE) || this.equals(Platforms.MAGMA) || this.equals(Platforms.KETTING);
    }

    default public boolean isNeoForge() {
        return this.equals(Platforms.NEOFORGE);
    }

    default public boolean isHybrid() {
        return this.equals(Platforms.MOHIST) || this.equals(Platforms.ARCLIGHT) || this.isForgeHybrid() || this.isFabricHybrid();
    }

    default public boolean isSponge() {
        return this.equals(Platforms.SPONGE);
    }

    default public boolean isVelocity() {
        return this.equals(Platforms.VELOCITY);
    }

    default public boolean isProxy() {
        return this.isBungeeCord() || this.isVelocity();
    }

    @NestHost(value=Platform.class)
    public static interface Meta {
        @NotNull
        public Object server();

        @NotNull
        public Object client();

        @NotNull
        public Object minecraft();

        @NotNull
        public Side side();

        public boolean isClient();

        @NotNull
        public MinecraftVersion minecraftVersion();

        @NotNull
        public String loaderVersion();

        @NotNull
        public String apiVersion();

        @NotNull
        public List<ModInfo> mods();

        @NotNull
        public Logger logger(@NotNull String var1);

        default public boolean isModLoaded(String ... nameOrId) {
            Objects.requireNonNull(nameOrId, "Mod name or ID cannot be null");
            for (ModInfo mod : this.mods()) {
                for (String s : nameOrId) {
                    if (!mod.id().equalsIgnoreCase(s) && !mod.name().equalsIgnoreCase(s)) continue;
                    return true;
                }
            }
            return false;
        }

        default public boolean areModsLoaded(String ... nameOrId) {
            Objects.requireNonNull(nameOrId, "Mod name or ID cannot be null");
            for (ModInfo mod : this.mods()) {
                boolean found = false;
                for (String s : nameOrId) {
                    if (!mod.id().equalsIgnoreCase(s) && !mod.name().equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @NotNull
        default public Path modsFolder() {
            return PathUtils.getModsFolder();
        }

        @NotNull
        default public Path configFolder() {
            return PathUtils.getConfigFolder();
        }
    }
}

