/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.JavaLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.adde0109.pcf.lib.taterapi.util.PathUtils;
import org.jetbrains.annotations.NotNull;

public final class BungeeCordMeta
implements Platform.Meta {
    @Override
    @NotNull
    public Object server() {
        return ProxyServer.getInstance();
    }

    @Override
    @NotNull
    public Object client() {
        throw new UnsupportedOperationException("BungeeCord does not run on the client");
    }

    @Override
    @NotNull
    public Object minecraft() {
        throw new UnsupportedOperationException("BungeeCord does not have a MinecraftServer");
    }

    @Override
    @NotNull
    public Side side() {
        return Side.PROXY;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return MinecraftVersion.of(ProxyServer.getInstance().getGameVersion());
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return ProxyServer.getInstance().getVersion();
    }

    @Override
    @NotNull
    public String apiVersion() {
        return ProxyServer.getInstance().getVersion();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return ProxyServer.getInstance().getPluginManager().getPlugins().stream().map(plugin -> new ModInfoImpl(plugin.getDescription().getName(), plugin.getDescription().getName(), plugin.getDescription().getVersion(), Platforms.BUNGEECORD)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new JavaLogger(modId, ProxyServer.getInstance().getLogger());
    }

    @Override
    @NotNull
    public Path modsFolder() {
        return PathUtils.getPluginsFolder();
    }

    @Override
    @NotNull
    public Path configFolder() {
        return PathUtils.getPluginsFolder();
    }
}

