/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adde0109.pcf.lib.jvmdg.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.jetbrains.annotations.NotNull;
import space.vectrix.ignite.Ignite;

public final class IgniteMeta
implements Platform.Meta {
    @NotNull
    private Platform.Meta underlyingPlatform() {
        MetaAPI api = MetaAPI.instance();
        Optional<Object> meta = Optional.empty();
        if (api.isPlatformPresent(Platforms.VELOCITY)) {
            meta = api.meta(Platforms.VELOCITY);
        } else if (api.isPlatformPresent(Platforms.BUNGEECORD)) {
            meta = api.meta(Platforms.BUNGEECORD);
        } else if (api.isPlatformPresent(Platforms.PAPER)) {
            meta = api.meta(Platforms.PAPER);
        } else if (api.isPlatformPresent(Platforms.SPIGOT)) {
            meta = api.meta(Platforms.SPIGOT);
        } else if (api.isPlatformPresent(Platforms.BUKKIT)) {
            meta = api.meta(Platforms.BUKKIT);
        }
        if (J_U_Optional.isEmpty(meta)) {
            throw new IllegalStateException("Ignite is not running a supported server platform.");
        }
        return (Platform.Meta)meta.get();
    }

    @Override
    @NotNull
    public Object server() {
        return this.underlyingPlatform().server();
    }

    @Override
    @NotNull
    public Object client() {
        return this.underlyingPlatform().client();
    }

    @Override
    @NotNull
    public Object minecraft() {
        return this.underlyingPlatform().minecraft();
    }

    @Override
    @NotNull
    public Side side() {
        return this.underlyingPlatform().side();
    }

    @Override
    public boolean isClient() {
        return this.underlyingPlatform().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return this.underlyingPlatform().minecraftVersion();
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return "0.0.0";
    }

    @Override
    @NotNull
    public String apiVersion() {
        return "0.0.0";
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return Ignite.mods().containers().stream().map(modContainer -> new ModInfoImpl(modContainer.id(), modContainer.id(), modContainer.version(), Platforms.IGNITE)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String pluginId) {
        return this.underlyingPlatform().logger(pluginId);
    }
}

