/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta;

import java.util.List;
import java.util.stream.Collectors;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.Slf4jLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.neoforge.NeoForgeData;
import org.jetbrains.annotations.NotNull;

public final class NeoForgeMeta
implements Platform.Meta {
    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return this.minecraft();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    @NotNull
    public Side side() {
        return WMinecraft.determineSide(this.isClient());
    }

    @Override
    public boolean isClient() {
        return NeoForgeData.dist().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return MinecraftVersion.of(NeoForgeData.versionInfo().mcVersion());
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return NeoForgeData.versionInfo().fmlVersion();
    }

    @Override
    @NotNull
    public String apiVersion() {
        return NeoForgeData.versionInfo().neoForgeVersion();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        List mods = null;
        if (ModList.get() != null) {
            mods = ModList.get().getMods();
        }
        if (mods == null || mods.isEmpty()) {
            mods = LoadingModList.get().getMods();
        }
        return mods.stream().map(modContainer -> new ModInfoImpl(modContainer.getModId(), modContainer.getDisplayName(), modContainer.getVersion().toString(), Platforms.NEOFORGE)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new Slf4jLogger(modId);
    }
}

