/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta;

import com.google.inject.Inject;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.Slf4jLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.adde0109.pcf.lib.taterapi.util.PathUtils;
import org.jetbrains.annotations.NotNull;

public final class VelocityMeta
implements Platform.Meta {
    @Inject
    private ProxyServer proxyServer;

    @Override
    @NotNull
    public Object server() {
        return this.proxyServer;
    }

    @Override
    @NotNull
    public Object client() {
        throw new UnsupportedOperationException("Velocity does not run on the client");
    }

    @Override
    @NotNull
    public Object minecraft() {
        throw new UnsupportedOperationException("Velocity does not have a MinecraftServer");
    }

    @Override
    @NotNull
    public Side side() {
        return Side.PROXY;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return MinecraftVersion.of(ProtocolVersion.MAXIMUM_VERSION.toString());
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return this.proxyServer.getVersion().getVersion();
    }

    @Override
    @NotNull
    public String apiVersion() {
        return this.proxyServer.getVersion().getVersion();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return this.proxyServer.getPluginManager().getPlugins().stream().map(plugin -> new ModInfoImpl(plugin.getDescription().getId(), plugin.getDescription().getName().orElse("Unknown"), plugin.getDescription().getVersion().orElse("Unknown"), Platforms.VELOCITY)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new Slf4jLogger(modId);
    }

    @Override
    @NotNull
    public Path modsFolder() {
        return PathUtils.getPluginsFolder();
    }

    @Override
    @NotNull
    public Path configFolder() {
        return PathUtils.getPluginsFolder();
    }
}

