/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.JavaLogger;
import org.adde0109.pcf.lib.taterapi.meta.MetaAPI;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.bukkit.PaperMeta;
import org.adde0109.pcf.lib.taterapi.util.PathUtils;
import org.adde0109.pcf.lib.taterapi.util.ReflectionUtil;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class BukkitMeta
implements Platform.Meta {
    @Override
    @NotNull
    public Object server() {
        return Bukkit.getServer();
    }

    @Override
    @NotNull
    public Object client() {
        throw new UnsupportedOperationException("Bukkit does not run on the client");
    }

    @Override
    @NotNull
    public Object minecraft() {
        try {
            String clazz = BukkitMeta.jvmdowngrader$concat$minecraft$1(Bukkit.getServer().getClass().getPackage().getName());
            Class<?> craftServer = Class.forName(clazz);
            return craftServer.getDeclaredMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public Side side() {
        return Side.SERVER;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        String version = Bukkit.getVersion();
        if (MetaAPI.instance().isPlatformPresent(Platforms.PAPER) && ReflectionUtil.checkForMethod("org.bukkit.Bukkit", "getMinecraftVersion")) {
            version = PaperMeta.getMinecraftVersion();
        }
        return MinecraftVersion.of(version);
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return Bukkit.getBukkitVersion();
    }

    @Override
    @NotNull
    public String apiVersion() {
        return Bukkit.getBukkitVersion();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return Arrays.stream(Bukkit.getServer().getPluginManager().getPlugins()).map(plugin -> new ModInfoImpl(plugin.getDescription().getName(), plugin.getDescription().getName(), plugin.getDescription().getVersion(), Platforms.BUKKIT)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new JavaLogger(modId, Bukkit.getLogger());
    }

    @Override
    @NotNull
    public Path modsFolder() {
        return PathUtils.getPluginsFolder();
    }

    @Override
    @NotNull
    public Path configFolder() {
        return PathUtils.getPluginsFolder();
    }

    private static String jvmdowngrader$concat$minecraft$1(String string) {
        return string + ".CraftServer";
    }
}

