/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.util.List;
import java.util.stream.Collectors;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.ApacheLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge.ForgeVersion_7_12;
import org.jetbrains.annotations.NotNull;

final class CPWLoaderMeta
implements Platform.Meta {
    CPWLoaderMeta() {
    }

    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return this.minecraft();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    @Override
    @NotNull
    public Side side() {
        return WMinecraft.determineSide(this.isClient());
    }

    @Override
    public boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        String version = "Unknown";
        try {
            version = (String)Loader.class.getField("MC_VERSION").get(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return MinecraftVersion.of(version);
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return ForgeVersion_7_12.forgeVersion();
    }

    @Override
    @NotNull
    public String apiVersion() {
        return ForgeVersion_7_12.forgeVersion();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return Loader.instance().getModList().stream().map(modContainer -> new ModInfoImpl(modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), Platforms.FORGE)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new ApacheLogger(modId);
    }
}

