/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge;

import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LauncherVersion;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.ApacheLogger;
import org.adde0109.pcf.lib.taterapi.logger.impl.Slf4jLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersions;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge.ForgeVersion_13_16;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.forge.ForgeVersion_17_21;
import org.adde0109.pcf.lib.taterapi.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

final class FMLLoaderMeta
implements Platform.Meta {
    private final boolean oldLifeCycleHooks = ReflectionUtil.checkForClass("net.minecraftforge.fml.server.ServerLifecycleHooks");

    FMLLoaderMeta() {
    }

    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return this.minecraft();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        if (this.oldLifeCycleHooks) {
            return net.minecraftforge.fml.server.ServerLifecycleHooks.getCurrentServer();
        }
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    @NotNull
    public Side side() {
        return WMinecraft.determineSide(this.isClient());
    }

    @Override
    public boolean isClient() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        String version = "Unknown";
        try {
            try {
                Object versionInfoObject = FMLLoader.class.getMethod("versionInfo", new Class[0]).invoke(null, new Object[0]);
                version = (String)versionInfoObject.getClass().getMethod("mcVersion", new Class[0]).invoke(versionInfoObject, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                Field mcVersionField = FMLLoader.class.getDeclaredField("mcVersion");
                mcVersionField.setAccessible(true);
                version = (String)mcVersionField.get(null);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return MinecraftVersion.of(version);
    }

    @Override
    @NotNull
    public String loaderVersion() {
        return LauncherVersion.getVersion();
    }

    @Override
    @NotNull
    public String apiVersion() {
        if (this.minecraftVersion().isOlderThan(MinecraftVersions.V17)) {
            return ForgeVersion_13_16.forgeVersion();
        }
        return ForgeVersion_17_21.forgeVersion();
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        List mods = null;
        if (ModList.get() != null) {
            mods = ModList.get().getMods();
        }
        if (mods == null || mods.isEmpty()) {
            mods = LoadingModList.get().getMods();
        }
        return mods.stream().map(modContainer -> new ModInfoImpl(modContainer.getModId(), modContainer.getDisplayName(), modContainer.getVersion().toString(), Platforms.FORGE)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        MinecraftVersion version = this.minecraftVersion();
        if (version.isOlderThan(MinecraftVersions.V18_2)) {
            return new ApacheLogger(modId);
        }
        return new Slf4jLogger(modId);
    }
}

