/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.sponge;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adde0109.pcf.lib.taterapi.logger.Logger;
import org.adde0109.pcf.lib.taterapi.logger.impl.ApacheLogger;
import org.adde0109.pcf.lib.taterapi.meta.MinecraftVersion;
import org.adde0109.pcf.lib.taterapi.meta.ModInfo;
import org.adde0109.pcf.lib.taterapi.meta.Platform;
import org.adde0109.pcf.lib.taterapi.meta.Platforms;
import org.adde0109.pcf.lib.taterapi.meta.Side;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraft;
import org.adde0109.pcf.lib.taterapi.meta.impl.WMinecraftServer;
import org.adde0109.pcf.lib.taterapi.meta.impl.platform.meta.ModInfoImpl;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.plugin.PluginContainer;

final class SpongeModernMeta
implements Platform.Meta {
    SpongeModernMeta() {
    }

    @Override
    @NotNull
    public Object server() {
        if (this.side().isServer()) {
            return Sponge.server();
        }
        return this.client();
    }

    @Override
    @NotNull
    public Object client() {
        return WMinecraft.getInstance();
    }

    @Override
    @NotNull
    public Object minecraft() {
        if (this.side().isClient() && WMinecraft.hasServer()) {
            return WMinecraft.getServer();
        }
        return this.server();
    }

    @Override
    @NotNull
    public Side side() {
        if (Sponge.server() == null) {
            return Side.CLIENT;
        }
        return WMinecraftServer.isDedicatedServer(Sponge.server()) ? Side.INTEGRATED : Side.SERVER;
    }

    @Override
    public boolean isClient() {
        return this.side().isClient();
    }

    @Override
    @NotNull
    public MinecraftVersion minecraftVersion() {
        return MinecraftVersion.of(Sponge.platform().minecraftVersion().name());
    }

    @Override
    @NotNull
    public String loaderVersion() {
        Optional container = Sponge.pluginManager().plugin("sponge");
        if (container.isPresent()) {
            return ((PluginContainer)container.get()).metadata().version().toString();
        }
        return "Unknown";
    }

    @Override
    @NotNull
    public String apiVersion() {
        Optional container = Sponge.pluginManager().plugin("sponge-api");
        if (container.isPresent()) {
            return ((PluginContainer)container.get()).metadata().version().toString();
        }
        return "Unknown";
    }

    @Override
    @NotNull
    public List<ModInfo> mods() {
        return Sponge.pluginManager().plugins().stream().map(pluginContainer -> new ModInfoImpl(pluginContainer.metadata().id(), pluginContainer.metadata().name().orElse(""), pluginContainer.metadata().version().toString(), Platforms.SPONGE)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Logger logger(@NotNull String modId) {
        return new ApacheLogger(modId);
    }
}

