/*
 * Decompiled with CFR 0.152.
 */
package org.adde0109.pcf.lib.taterapi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={NumericVersionComponent.class, SemVerPrereleaseVersionComponent.class, VersionComponent.class, 1.class})
public class FlexVerComparator {
    private static final VersionComponent NULL = new VersionComponent(new int[0]){

        @Override
        public int compareTo(VersionComponent other) {
            return other == FlexVerComparator.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_util_FlexVerComparator$get$NULL() ? 0 : -other.compareTo(this);
        }
    };

    public static int compare(String a, String b) {
        List<VersionComponent> ad = FlexVerComparator.decompose(a);
        List<VersionComponent> bd = FlexVerComparator.decompose(b);
        for (int i = 0; i < Math.max(ad.size(), bd.size()); ++i) {
            int c = FlexVerComparator.get(ad, i).compareTo(FlexVerComparator.get(bd, i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    static List<VersionComponent> decompose(String str) {
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        boolean lastWasNumber = FlexVerComparator.isAsciiDigit(str.codePointAt(0));
        int totalCodepoints = str.codePointCount(0, str.length());
        int[] accum = new int[totalCodepoints];
        ArrayList<VersionComponent> out = new ArrayList<VersionComponent>();
        int j = 0;
        for (int i = 0; i < str.length(); ++i) {
            int cp = str.codePointAt(i);
            if (Character.charCount(cp) == 2) {
                ++i;
            }
            if (cp == 43) break;
            boolean number = FlexVerComparator.isAsciiDigit(cp);
            if (number != lastWasNumber || cp == 45 && j > 0 && accum[0] != 45) {
                out.add(FlexVerComparator.createComponent(lastWasNumber, accum, j));
                j = 0;
                lastWasNumber = number;
            }
            accum[j] = cp;
            ++j;
        }
        out.add(FlexVerComparator.createComponent(lastWasNumber, accum, j));
        return out;
    }

    private static boolean isAsciiDigit(int cp) {
        return cp >= 48 && cp <= 57;
    }

    private static VersionComponent createComponent(boolean number, int[] s, int j) {
        s = Arrays.copyOfRange(s, 0, j);
        if (number) {
            return new NumericVersionComponent(s);
        }
        if (s.length > 1 && s[0] == 45) {
            return new SemVerPrereleaseVersionComponent(s);
        }
        return new VersionComponent(s);
    }

    private static VersionComponent get(List<VersionComponent> li, int i) {
        return i >= li.size() ? NULL : li.get(i);
    }

    static VersionComponent jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_util_FlexVerComparator$get$NULL() {
        return NULL;
    }

    static void jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_util_FlexVerComparator$set$NULL(VersionComponent versionComponent) {
        NULL = versionComponent;
    }

    @NestHost(value=FlexVerComparator.class)
    static class VersionComponent {
        private final int[] codepoints;

        public VersionComponent(int[] codepoints) {
            this.codepoints = codepoints;
        }

        public int[] codepoints() {
            return this.codepoints;
        }

        public int compareTo(VersionComponent that) {
            if (that == FlexVerComparator.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_util_FlexVerComparator$get$NULL()) {
                return 1;
            }
            int[] a = this.codepoints();
            int[] b = that.codepoints();
            for (int i = 0; i < Math.min(a.length, b.length); ++i) {
                int c1 = a[i];
                int c2 = b[i];
                if (c1 == c2) continue;
                return c1 - c2;
            }
            return a.length - b.length;
        }

        public String toString() {
            return new String(this.codepoints, 0, this.codepoints.length);
        }
    }

    @NestHost(value=FlexVerComparator.class)
    static class NumericVersionComponent
    extends VersionComponent {
        public NumericVersionComponent(int[] codepoints) {
            super(codepoints);
        }

        @Override
        public int compareTo(VersionComponent that) {
            if (that == FlexVerComparator.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_util_FlexVerComparator$get$NULL()) {
                return 1;
            }
            if (that instanceof NumericVersionComponent) {
                int[] b;
                int[] a = this.removeLeadingZeroes(this.codepoints());
                if (a.length != (b = this.removeLeadingZeroes(that.codepoints())).length) {
                    return a.length - b.length;
                }
                for (int i = 0; i < a.length; ++i) {
                    int ad = a[i];
                    int bd = b[i];
                    if (ad == bd) continue;
                    return ad - bd;
                }
                return 0;
            }
            return super.compareTo(that);
        }

        private int[] removeLeadingZeroes(int[] a) {
            int i;
            if (a.length == 1) {
                return a;
            }
            int stopIdx = a.length - 1;
            for (i = 0; i < stopIdx && a[i] == 48; ++i) {
            }
            return Arrays.copyOfRange(a, i, a.length);
        }
    }

    @NestHost(value=FlexVerComparator.class)
    static class SemVerPrereleaseVersionComponent
    extends VersionComponent {
        public SemVerPrereleaseVersionComponent(int[] codepoints) {
            super(codepoints);
        }

        @Override
        public int compareTo(VersionComponent that) {
            if (that == FlexVerComparator.jvmdowngrader$nest$org_adde0109_pcf_lib_taterapi_util_FlexVerComparator$get$NULL()) {
                return -1;
            }
            return super.compareTo(that);
        }
    }
}

