/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.config;

import com.axalotl.async.common.platform.PlatformEvents;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConfig {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Async Config");
    public static boolean disabled = false;
    public static int paraMax = -1;
    public static boolean enableAsyncSpawn = true;
    public static boolean enableAsyncRandomTicks = false;
    public static Set<class_2960> synchronizedEntities = AsyncConfig.getDefaultSynchronizedEntities();

    public static Set<class_2960> getDefaultSynchronizedEntities() {
        return Set.of(Objects.requireNonNull(class_2960.method_43902((String)"minecraft", (String)"tnt")), Objects.requireNonNull(class_2960.method_43902((String)"minecraft", (String)"item")), Objects.requireNonNull(class_2960.method_43902((String)"minecraft", (String)"experience_orb")));
    }

    public static int getParallelism() {
        if (paraMax <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), paraMax));
    }

    public static void syncEntity(class_2960 entityId) {
        if (synchronizedEntities.add(entityId)) {
            PlatformEvents.getInstance().saveConfig();
            LOGGER.info("Sync entity class: {}", (Object)entityId);
        } else {
            LOGGER.warn("Entity class already synchronized: {}", (Object)entityId);
        }
    }

    public static void asyncEntity(class_2960 entityId) {
        if (synchronizedEntities.remove(entityId)) {
            PlatformEvents.getInstance().saveConfig();
            LOGGER.info("Enable async process entity class: {}", (Object)entityId);
        } else {
            LOGGER.warn("Entity class not found: {}", (Object)entityId);
        }
    }
}

