/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.lithium;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.caffeinemc.mods.lithium.common.world.chunk.ChunkHolderExtended;
import net.caffeinemc.mods.lithium.mixin.world.chunk_access.GenerationChunkHolderAccessor;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2821;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3898;
import net.minecraft.class_8563;
import net.minecraft.class_9259;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3215.class})
public abstract class LithiumServerChunkCacheMixin
extends class_2802 {
    @Shadow
    @Final
    public class_3215.class_4212 field_18809;
    @Shadow
    @Final
    public class_3898 field_17254;
    @Shadow
    @Final
    Thread field_17253;
    @Unique
    private long async$time;
    @Unique
    private final long[] async$cacheKeys = new long[4];
    @Unique
    private final class_2791[] async$cacheChunks = new class_2791[4];
    @Unique
    private final Object async$cacheLock = new Object();
    @Shadow
    @Final
    public class_3218 field_13945;

    @Shadow
    public abstract class_3193 method_14131(long var1);

    @Shadow
    protected abstract boolean method_18752(class_3193 var1, int var2);

    @Shadow
    public abstract void method_12127(@NotNull BooleanSupplier var1, boolean var2);

    @Shadow
    abstract boolean method_16155();

    @Shadow
    public abstract void method_66008(class_3228 var1, class_1923 var2);

    @Shadow
    public abstract void method_66010(class_3230 var1, class_1923 var2, int var3);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void preTick(BooleanSupplier shouldKeepTicking, boolean tickChunks, CallbackInfo ci) {
        ++this.async$time;
    }

    @Overwrite
    @Nullable
    public class_2791 method_12121(int x, int z, @NotNull class_2806 status, boolean create) {
        if (Thread.currentThread() != this.field_17253) {
            return this.async$getChunkOffThread(x, z, status, create);
        }
        long key = LithiumServerChunkCacheMixin.async$createCacheKey(x, z, status);
        for (int i = 0; i < 4; ++i) {
            class_2791 chunk;
            if (key != this.async$cacheKeys[i] || (chunk = this.async$cacheChunks[i]) == null && create) continue;
            return chunk;
        }
        class_2791 chunk = this.async$getChunkBlocking(x, z, status, create);
        if (chunk != null) {
            this.async$addToCache(key, chunk);
        } else if (create) {
            throw new IllegalStateException("Chunk not there when requested");
        }
        return chunk;
    }

    @Unique
    private class_2791 async$getChunkOffThread(int x, int z, class_2806 status, boolean create) {
        class_2791 ifPresent;
        long pos = class_1923.method_8331((int)x, (int)z);
        class_3193 holder = this.method_14131(pos);
        class_2791 class_27912 = ifPresent = holder == null ? null : holder.method_60463(status);
        if (ifPresent != null) {
            if (ifPresent instanceof class_2821) {
                class_2821 proto = (class_2821)ifPresent;
                return proto.method_12240();
            }
            return ifPresent;
        }
        return create ? this.async$syncLoad(x, z, status) : null;
    }

    @Unique
    private class_2791 async$syncLoad(int chunkX, int chunkZ, class_2806 status) {
        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
        CompletableFuture future = new CompletableFuture();
        this.field_18809.execute(() -> {
            this.method_66008(new class_3228(class_3230.field_14031, class_8563.method_51829((class_2806)status)), chunkPos);
            this.method_16155();
            class_3193 holder = this.method_14131(chunkPos.method_8324());
            if (holder == null) {
                this.method_66010(class_3230.field_14032, chunkPos, 0);
                future.completeExceptionally(new IllegalStateException("ChunkHolder is null"));
                return;
            }
            holder.method_60458(status, this.field_17254).whenCompleteAsync((optChunk, throwable) -> {
                this.method_66010(class_3230.field_14032, chunkPos, 0);
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                    return;
                }
                class_2791 chunk = (class_2791)optChunk.method_57130(null);
                if (chunk instanceof class_2821) {
                    class_2821 readOnlyChunk = (class_2821)chunk;
                    chunk = readOnlyChunk.method_12240();
                }
                if (chunk == null) {
                    future.completeExceptionally(new IllegalStateException("Chunk not loaded when requested"));
                } else {
                    future.complete(chunk);
                }
            }, (Executor)this.field_18809);
        });
        return (class_2791)future.join();
    }

    @Unique
    private class_2791 async$getChunkBlocking(int x, int z, class_2806 leastStatus, boolean create) {
        class_2791 chunk;
        CompletableFuture directlyAccessedFuture;
        long key = class_1923.method_8331((int)x, (int)z);
        int level = class_8563.method_51829((class_2806)leastStatus);
        class_3193 holder = this.method_14131(key);
        if (this.method_18752(holder, level)) {
            if (!create) {
                return null;
            }
            this.async$createChunkLoadTicket(x, z, level);
            this.method_16155();
            holder = this.method_14131(key);
            if (this.method_18752(holder, level)) {
                throw (IllegalStateException)class_156.method_22320((Throwable)new IllegalStateException("No chunk holder after ticket has been added"));
            }
        } else if (create && ((ChunkHolderExtended)holder).lithium$updateLastAccessTime(this.async$time)) {
            this.async$createChunkLoadTicket(x, z, level);
        }
        if (!((GenerationChunkHolderAccessor)holder).invokeCannotBeLoaded(leastStatus) && (directlyAccessedFuture = (CompletableFuture)((GenerationChunkHolderAccessor)holder).lithium$getChunkFuturesByStatus().get(leastStatus.method_16559())) != null && directlyAccessedFuture.isDone() && (chunk = (class_2791)((class_9259)directlyAccessedFuture.join()).method_57130(null)) != null) {
            return chunk;
        }
        CompletableFuture loadFuture = holder.method_60458(leastStatus, this.field_17254);
        if (!loadFuture.isDone()) {
            class_3215.class_4212 var10000 = this.field_18809;
            Objects.requireNonNull(loadFuture);
            var10000.method_18857(loadFuture::isDone);
        }
        return (class_2791)((class_9259)loadFuture.join()).method_57130(null);
    }

    @Unique
    private void async$createChunkLoadTicket(int x, int z, int level) {
        class_1923 chunkPos = new class_1923(x, z);
        this.method_66008(new class_3228(class_3230.field_14032, level), chunkPos);
    }

    @Unique
    private static long async$createCacheKey(int chunkX, int chunkZ, class_2806 status) {
        return (long)chunkX & 0xFFFFFFFL | ((long)chunkZ & 0xFFFFFFFL) << 28 | (long)status.method_16559() << 56;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void async$addToCache(long key, class_2791 chunk) {
        Object object = this.async$cacheLock;
        synchronized (object) {
            for (int i = 3; i > 0; --i) {
                this.async$cacheKeys[i] = this.async$cacheKeys[i - 1];
                this.async$cacheChunks[i] = this.async$cacheChunks[i - 1];
            }
            this.async$cacheKeys[0] = key;
            this.async$cacheChunks[0] = chunk;
        }
    }

    @Inject(method={"clearCache()V"}, at={@At(value="HEAD")})
    private void onCachesCleared(CallbackInfo ci) {
        Arrays.fill(this.async$cacheKeys, Long.MAX_VALUE);
        Arrays.fill(this.async$cacheChunks, null);
    }
}

