/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.parallelised.fastutil;

import com.axalotl.async.common.parallelised.fastutil.FastUtilHackUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class Long2ObjectConcurrentHashMap<V>
implements Long2ObjectMap<V> {
    private final ConcurrentHashMap<Long, V> backing = new ConcurrentHashMap();
    private V defaultReturnValue;

    public V get(long key) {
        V value = this.backing.get(key);
        return value == null && !this.backing.containsKey(key) ? this.defaultReturnValue : value;
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    public void putAll(@NotNull Map<? extends Long, ? extends V> m) {
        Objects.requireNonNull(m, "Source map cannot be null");
        this.backing.putAll(m);
    }

    public int size() {
        return this.backing.size();
    }

    public void defaultReturnValue(V rv) {
        this.defaultReturnValue = rv;
    }

    public V defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public ObjectSet<Long2ObjectMap.Entry<V>> long2ObjectEntrySet() {
        return FastUtilHackUtil.entrySetLongWrap(this.backing);
    }

    @NotNull
    public LongSet keySet() {
        return FastUtilHackUtil.wrapLongSet(this.backing.keySet());
    }

    @NotNull
    public ObjectCollection<V> values() {
        return FastUtilHackUtil.wrap(this.backing.values());
    }

    public boolean containsKey(long key) {
        return this.backing.containsKey(key);
    }

    public V put(long key, V value) {
        V previous = this.backing.put(key, value);
        return previous == null && !this.backing.containsKey(key) ? this.defaultReturnValue : previous;
    }

    public V remove(long key) {
        V previous = this.backing.remove(key);
        return previous == null && !this.backing.containsKey(key) ? this.defaultReturnValue : previous;
    }

    public void clear() {
        this.backing.clear();
    }

    public V getOrDefault(long key, V defaultValue) {
        V value = this.backing.get(key);
        return value == null && !this.backing.containsKey(key) ? defaultValue : value;
    }

    public V putIfAbsent(long key, V value) {
        V previous = this.backing.putIfAbsent(key, value);
        return previous == null && !this.backing.containsKey(key) ? this.defaultReturnValue : previous;
    }

    public boolean remove(long key, Object value) {
        V previous = this.backing.remove(key);
        return this.backing.remove(key, previous);
    }

    public boolean replace(long key, V oldValue, V newValue) {
        return this.backing.replace(key, oldValue, newValue);
    }

    public V replace(long key, V value) {
        V previous = this.backing.replace(key, value);
        return previous == null && !this.backing.containsKey(key) ? this.defaultReturnValue : previous;
    }

    public V compute(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "Remapping function cannot be null");
        V newValue = this.backing.compute(key, remappingFunction);
        return newValue == null && !this.backing.containsKey(key) ? this.defaultReturnValue : newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Long2ObjectMap)) {
            return false;
        }
        Long2ObjectMap that = (Long2ObjectMap)o;
        if (this.size() != that.size()) {
            return false;
        }
        return this.long2ObjectEntrySet().containsAll((Collection)that.long2ObjectEntrySet());
    }

    public int hashCode() {
        return this.backing.hashCode();
    }

    public String toString() {
        return this.backing.toString();
    }
}

