/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.fabric.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class AsyncConfig {
    private static final Supplier<CommentedFileConfig> configSupplier = () -> (CommentedFileConfig)CommentedFileConfig.builder((Path)FabricLoader.getInstance().getConfigDir().resolve("async.toml")).preserveInsertionOrder().sync().build();
    private static CommentedFileConfig CONFIG;

    public static void init() {
        com.axalotl.async.common.config.AsyncConfig.LOGGER.info("Initializing Async Config...");
        CONFIG = configSupplier.get();
        try {
            if (!CONFIG.getFile().exists()) {
                com.axalotl.async.common.config.AsyncConfig.LOGGER.warn("Configuration file not found, creating default configuration.");
                AsyncConfig.setDefaultValues();
                AsyncConfig.saveConfig();
            } else {
                CONFIG.load();
                AsyncConfig.loadConfigValues();
                com.axalotl.async.common.config.AsyncConfig.LOGGER.info("Configuration successfully loaded.");
            }
        }
        catch (Throwable t) {
            com.axalotl.async.common.config.AsyncConfig.LOGGER.error("Error loading configuration, resetting to default values.", t);
            AsyncConfig.setDefaultValues();
            AsyncConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        CONFIG.set("disabled", (Object)com.axalotl.async.common.config.AsyncConfig.disabled);
        CONFIG.setComment("disabled", "Enables parallel processing of entity.");
        CONFIG.set("paraMax", (Object)com.axalotl.async.common.config.AsyncConfig.paraMax);
        CONFIG.setComment("paraMax", "Maximum number of threads to use for parallel processing. Set to -1 to use default value. Note: If 'virtualThreads' is enabled, this setting will be ignored.");
        CONFIG.set("synchronizedEntities", com.axalotl.async.common.config.AsyncConfig.synchronizedEntities.stream().map(class_2960::toString).toList());
        CONFIG.setComment("synchronizedEntities", "List of entity class for sync processing.");
        CONFIG.set("enableAsyncSpawn", (Object)com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn);
        CONFIG.setComment("enableAsyncSpawn", "Enables parallel processing of entity spawns. Warning, incompatible with Carpet mod lagFreeSpawning rule.");
        CONFIG.set("enableAsyncRandomTicks", (Object)com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks);
        CONFIG.setComment("enableAsyncRandomTicks", "Experimental! Enables async processing of random ticks.");
        CONFIG.save();
        com.axalotl.async.common.config.AsyncConfig.LOGGER.info("Configuration saved successfully.");
    }

    private static void loadConfigValues() {
        HashSet<String> processedKeys = new HashSet<String>(List.of("disabled", "paraMax", "synchronizedEntities", "enableAsyncSpawn", "enableAsyncRandomTicks"));
        com.axalotl.async.common.config.AsyncConfig.disabled = (Boolean)CONFIG.getOrElse("disabled", (Object)com.axalotl.async.common.config.AsyncConfig.disabled);
        com.axalotl.async.common.config.AsyncConfig.paraMax = (Integer)CONFIG.getOrElse("paraMax", (Object)com.axalotl.async.common.config.AsyncConfig.paraMax);
        com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn = (Boolean)CONFIG.getOrElse("enableAsyncSpawn", (Object)com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn);
        com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks = (Boolean)CONFIG.getOrElse("enableAsyncRandomTicks", (Object)com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks);
        List<String> ids = com.axalotl.async.common.config.AsyncConfig.synchronizedEntities.stream().map(class_2960::toString).toList();
        HashSet<class_2960> set = new HashSet<class_2960>();
        for (String id : ids) {
            class_2960 rl = class_2960.method_12829((String)id);
            if (rl == null) continue;
            set.add(rl);
        }
        com.axalotl.async.common.config.AsyncConfig.synchronizedEntities = set.isEmpty() ? com.axalotl.async.common.config.AsyncConfig.getDefaultSynchronizedEntities() : set;
        HashSet<String> keysToRemove = new HashSet<String>();
        for (CommentedConfig.Entry entry : CONFIG.entrySet()) {
            String key = entry.getKey();
            if (processedKeys.contains(key)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            com.axalotl.async.common.config.AsyncConfig.LOGGER.warn("Removing unused configuration key: {}", (Object)key);
            CONFIG.remove(key);
        }
        CONFIG.save();
    }

    private static void setDefaultValues() {
        com.axalotl.async.common.config.AsyncConfig.disabled = false;
        com.axalotl.async.common.config.AsyncConfig.paraMax = -1;
        com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn = true;
        com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks = false;
        com.axalotl.async.common.config.AsyncConfig.synchronizedEntities = com.axalotl.async.common.config.AsyncConfig.getDefaultSynchronizedEntities();
    }
}

