/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async;

import com.axalotl.async.Async;
import com.axalotl.async.config.AsyncConfig;
import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1540;
import net.minecraft.class_156;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1928;
import net.minecraft.class_1948;
import net.minecraft.class_2818;
import net.minecraft.class_2966;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9813;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ParallelProcessor.class);
    private static MinecraftServer server;
    public static final AtomicInteger currentEntities;
    private static final AtomicInteger threadPoolID;
    private static ExecutorService tickPool;
    private static final Queue<CompletableFuture<?>> taskQueue;
    private static final Set<UUID> blacklistedEntity;
    private static final Map<UUID, Integer> portalTickSyncMap;
    private static final Map<String, Set<Thread>> mcThreadTracker;
    private static final Set<Class<?>> specialEntities;

    public static void setupThreadPool(int parallelism) {
        ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("Async-Tick-Pool-Thread-" + threadPoolID.getAndIncrement());
            ParallelProcessor.registerThread("Async-Tick", worker);
            worker.setDaemon(true);
            worker.setPriority(5);
            worker.setContextClassLoader(Async.class.getClassLoader());
            return worker;
        };
        tickPool = new ForkJoinPool(parallelism, threadFactory, (t, e) -> LOGGER.error("Uncaught exception in thread {}: {}", (Object)t.getName(), (Object)e), true);
        LOGGER.info("Initialized Pool with {} threads", (Object)parallelism);
    }

    public static void registerThread(String poolName, Thread thread) {
        mcThreadTracker.computeIfAbsent(poolName, key -> ConcurrentHashMap.newKeySet()).add(thread);
    }

    private static boolean isThreadInPool(Thread thread) {
        return mcThreadTracker.getOrDefault("Async-Tick", Set.of()).contains(thread);
    }

    public static boolean isServerExecutionThread() {
        return ParallelProcessor.isThreadInPool(Thread.currentThread());
    }

    public static void callEntityTick(Consumer<class_1297> tickConsumer, class_1297 entity) {
        if (ParallelProcessor.shouldTickSynchronously(entity)) {
            ParallelProcessor.tickSynchronously(tickConsumer, entity);
        } else if (!tickPool.isShutdown() && !tickPool.isTerminated()) {
            CompletionStage future = CompletableFuture.runAsync(() -> ParallelProcessor.performAsyncEntityTick(tickConsumer, entity), tickPool).exceptionally(e -> {
                ParallelProcessor.logEntityError("Error in async tick, switching to synchronous", entity, e);
                ParallelProcessor.tickSynchronously(tickConsumer, entity);
                blacklistedEntity.add(entity.method_5667());
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            ParallelProcessor.logEntityError("Rejected task due to ExecutorService shutdown", entity, null);
            ParallelProcessor.tickSynchronously(tickConsumer, entity);
        }
    }

    public static boolean shouldTickSynchronously(class_1297 entity) {
        boolean requiresSyncTick;
        UUID entityId = entity.method_5667();
        boolean bl = requiresSyncTick = AsyncConfig.disabled || entity instanceof class_1676 || entity instanceof class_1688 || entity instanceof class_3222 || specialEntities.contains(entity.getClass()) || blacklistedEntity.contains(entityId) || AsyncConfig.synchronizedEntities.contains(class_1299.method_5890((class_1299)entity.method_5864())) || entity.method_5817();
        if (requiresSyncTick) {
            return true;
        }
        if (portalTickSyncMap.containsKey(entityId)) {
            int ticksLeft = portalTickSyncMap.get(entityId);
            if (ticksLeft > 0) {
                portalTickSyncMap.put(entityId, ticksLeft - 1);
                return true;
            }
            portalTickSyncMap.remove(entityId);
        }
        if (ParallelProcessor.isPortalTickRequired(entity)) {
            portalTickSyncMap.put(entityId, 39);
            return true;
        }
        return false;
    }

    private static boolean isPortalTickRequired(class_1297 entity) {
        return entity.field_51994 != null && entity.field_51994.method_60709();
    }

    private static void tickSynchronously(Consumer<class_1297> tickConsumer, class_1297 entity) {
        try {
            tickConsumer.accept(entity);
        }
        catch (Exception e) {
            ParallelProcessor.logEntityError("Error during synchronous tick", entity, e);
        }
    }

    private static void performAsyncEntityTick(Consumer<class_1297> tickConsumer, class_1297 entity) {
        currentEntities.incrementAndGet();
        try {
            tickConsumer.accept(entity);
        }
        finally {
            currentEntities.decrementAndGet();
        }
    }

    public static void asyncSpawn(class_3218 world, class_2818 chunk, class_1948.class_5262 info, boolean spawnAnimals, boolean spawnMonsters, boolean rareSpawn) {
        if (AsyncConfig.enableAsyncSpawn) {
            CompletionStage future = CompletableFuture.runAsync(() -> class_1948.method_27821((class_3218)world, (class_2818)chunk, (class_1948.class_5262)info, (boolean)spawnAnimals, (boolean)spawnMonsters, (boolean)rareSpawn), tickPool).exceptionally(e -> {
                LOGGER.error("Error in async spawn tick, switching to synchronous", e);
                class_1948.method_27821((class_3218)world, (class_2818)chunk, (class_1948.class_5262)info, (boolean)spawnAnimals, (boolean)spawnMonsters, (boolean)rareSpawn);
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            class_1948.method_27821((class_3218)world, (class_2818)chunk, (class_1948.class_5262)info, (boolean)spawnAnimals, (boolean)spawnMonsters, (boolean)rareSpawn);
        }
    }

    public static void postEntityTick() {
        if (!AsyncConfig.disabled) {
            long maxTickTime;
            CompletableFuture<?> future;
            ArrayList futuresList = new ArrayList();
            while ((future = taskQueue.poll()) != null) {
                futuresList.add(future);
            }
            CompletableFuture<Void> allTasks = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
            MinecraftServer minecraftServer = server;
            if (minecraftServer instanceof class_3176) {
                class_3176 dedicatedServer = (class_3176)minecraftServer;
                maxTickTime = dedicatedServer.method_13944();
            } else {
                maxTickTime = 60000L;
            }
            if (maxTickTime > 0L) {
                allTasks.orTimeout(maxTickTime, TimeUnit.MILLISECONDS).exceptionally(ex -> {
                    Throwable cause;
                    Throwable throwable = cause = ex instanceof CompletionException ? ex.getCause() : ex;
                    if (cause instanceof TimeoutException) {
                        ParallelProcessor.crash("Timeout during entity tick processing: ", cause);
                    } else {
                        LOGGER.error("Error during entity tick processing: ", cause);
                    }
                    return null;
                });
            } else {
                allTasks.exceptionally(ex -> {
                    Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
                    LOGGER.error("Error during entity tick processing: ", cause);
                    return null;
                });
            }
            server.method_3738().forEach(world -> {
                world.method_14178().method_19492();
                world.method_14178().field_18809.method_18857(allTasks::isDone);
            });
        }
    }

    public static void stop() {
        if (tickPool != null && !tickPool.isShutdown()) {
            tickPool.shutdown();
        }
    }

    public static void crash(String message, Throwable throwable) {
        String errorMessage = message + throwable.getMessage();
        LOGGER.error(errorMessage, (Object)LogUtils.FATAL_MARKER);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        StringBuilder stringBuilder = new StringBuilder();
        Error error = new Error("Watchdog");
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo.getThreadId() == server.method_3777().threadId()) {
                error.setStackTrace(threadInfo.getStackTrace());
            }
            stringBuilder.append(threadInfo);
            stringBuilder.append("\n");
        }
        class_128 crashReport = new class_128("Watching Server", (Throwable)error);
        server.method_37324(crashReport.method_567());
        class_129 crashReportSection = crashReport.method_562("Thread Dump");
        crashReportSection.method_578("Threads", (Object)stringBuilder);
        class_129 threadDumpSection = crashReport.method_562("Async thread dump");
        threadDumpSection.method_577("All Threads", () -> {
            StringBuilder sb = new StringBuilder();
            Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : allThreads.entrySet()) {
                Thread t = entry.getKey();
                sb.append(String.format("\"%s\" [%s]%n", new Object[]{t.getName(), t.getState()}));
                for (StackTraceElement ste : entry.getValue()) {
                    sb.append("\tat ").append(ste).append("\n");
                }
                sb.append("\n");
            }
            return sb.toString();
        });
        class_129 crashReportSection2 = crashReport.method_562("Performance stats");
        crashReportSection2.method_577("Random tick rate", () -> ((class_1928.class_4312)server.method_27728().method_146().method_20746(class_1928.field_19399)).toString());
        crashReportSection2.method_577("Level stats", () -> Streams.stream((Iterable)server.method_3738()).map(world -> String.valueOf(world.method_27983()) + ": " + world.method_31268()).collect(Collectors.joining(",\n")));
        class_2966.method_12847((String)("Crash report:\n" + crashReport.method_60920(class_9813.field_52181)));
        Path path = server.method_3831().resolve("crash-reports").resolve("crash-" + class_156.method_44893() + "-server.txt");
        if (crashReport.method_60919(path, class_9813.field_52181)) {
            LOGGER.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
        } else {
            LOGGER.error("We were unable to save this crash report to disk.");
        }
        ParallelProcessor.shutdown();
    }

    private static void shutdown() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable var2) {
            Runtime.getRuntime().halt(1);
        }
    }

    private static void logEntityError(String message, class_1297 entity, Throwable e) {
        LOGGER.error("{} Entity Type: {}, UUID: {}", (Object)message, (Object)entity.method_5864().method_5897(), (Object)entity.method_5667(), (Object)e);
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        ParallelProcessor.server = server;
    }

    static {
        currentEntities = new AtomicInteger();
        threadPoolID = new AtomicInteger();
        taskQueue = new ConcurrentLinkedQueue();
        blacklistedEntity = ConcurrentHashMap.newKeySet();
        portalTickSyncMap = new ConcurrentHashMap<UUID, Integer>();
        mcThreadTracker = new ConcurrentHashMap<String, Set<Thread>>();
        specialEntities = Set.of(class_1540.class);
    }
}

