/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.commands;

import com.axalotl.async.common.ParallelProcessor;
import com.axalotl.async.common.commands.AsyncCommand;
import com.axalotl.async.common.config.AsyncConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatsCommand {
    private static final Logger LOGGER = LogManager.getLogger(StatsCommand.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,##0.##");
    private static final int MAX_SAMPLES = 100;
    private static final long SAMPLING_INTERVAL_MS = 10L;
    private static final Queue<Integer> threadSamples = new ConcurrentLinkedQueue<Integer>();
    private static volatile boolean isRunning = true;
    private static Thread statsThread;

    public static LiteralArgumentBuilder<CommandSourceStack> registerStatus(LiteralArgumentBuilder<CommandSourceStack> root) {
        return (LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stats").requires(cmdSrc -> cmdSrc.hasPermission(4))).executes(cmdCtx -> {
            StatsCommand.showGeneralStats((CommandSourceStack)cmdCtx.getSource());
            return 1;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"entity").requires(cmdSrc -> cmdSrc.hasPermission(4))).executes(cmdCtx -> {
            StatsCommand.showEntityStats((CommandSourceStack)cmdCtx.getSource(), 0);
            return 1;
        })).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(cmdCtx -> {
            int count = IntegerArgumentType.getInteger((CommandContext)cmdCtx, (String)"count");
            StatsCommand.showEntityStats((CommandSourceStack)cmdCtx.getSource(), count);
            return 1;
        }))));
    }

    private static void showGeneralStats(CommandSourceStack source) {
        double avgThreads = StatsCommand.calculateAverageThreads();
        MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Performance Statistics ").withStyle(style -> style.withColor(ChatFormatting.GOLD))).append((Component)Component.literal((String)"\nAverage Active Processing Threads: ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)DECIMAL_FORMAT.format(Math.ceil(avgThreads))).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)"\nAsync Status: ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)(AsyncConfig.disabled ? "disabled" : "Enabled")).withStyle(style -> style.withColor(AsyncConfig.disabled ? ChatFormatting.RED : ChatFormatting.GREEN)));
        source.sendSuccess(() -> message, true);
    }

    private static void showEntityStats(CommandSourceStack source, int topCount) {
        MinecraftServer server = source.getServer();
        server.execute(() -> {
            HashMap entityTypeCounts = new HashMap();
            HashMap asyncEntityTypeCounts = new HashMap();
            AtomicInteger totalEntities = new AtomicInteger(0);
            AtomicInteger totalAsyncEntities = new AtomicInteger(0);
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Entity Statistics ").withStyle(style -> style.withColor(ChatFormatting.GOLD)));
            server.getAllLevels().forEach(world -> {
                String worldName = world.dimensionTypeRegistration().getRegisteredName();
                AtomicInteger worldCount = new AtomicInteger(0);
                AtomicInteger asyncCount = new AtomicInteger(0);
                world.getAllEntities().forEach(entity -> {
                    if (entity != null && entity.isAlive()) {
                        EntityType entityType = entity.getType();
                        worldCount.incrementAndGet();
                        totalEntities.incrementAndGet();
                        entityTypeCounts.merge(entityType, 1, Integer::sum);
                        if (!ParallelProcessor.shouldTickSynchronously(entity)) {
                            asyncCount.incrementAndGet();
                            totalAsyncEntities.incrementAndGet();
                            asyncEntityTypeCounts.merge(entityType, 1, Integer::sum);
                        }
                    }
                });
                message.append((Component)Component.literal((String)("\n" + worldName + ": ")).withStyle(style -> style.withColor(ChatFormatting.YELLOW))).append((Component)Component.literal((String)String.valueOf(worldCount.get())).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)" entities (").withStyle(style -> style.withColor(ChatFormatting.GRAY))).append((Component)Component.literal((String)String.valueOf(asyncCount.get())).withStyle(style -> style.withColor(ChatFormatting.AQUA))).append((Component)Component.literal((String)" async)").withStyle(style -> style.withColor(ChatFormatting.GRAY)));
            });
            message.append((Component)Component.literal((String)"\nTotal Entities: ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)String.valueOf(totalEntities.get())).withStyle(style -> style.withColor(ChatFormatting.GOLD))).append((Component)Component.literal((String)" (").withStyle(style -> style.withColor(ChatFormatting.GRAY))).append((Component)Component.literal((String)String.valueOf(totalAsyncEntities.get())).withStyle(style -> style.withColor(ChatFormatting.AQUA))).append((Component)Component.literal((String)" async)").withStyle(style -> style.withColor(ChatFormatting.GRAY)));
            if (topCount > 0) {
                List sortedEntities = new ArrayList(entityTypeCounts.entrySet());
                sortedEntities.sort(Map.Entry.comparingByValue().reversed());
                if (topCount < sortedEntities.size()) {
                    sortedEntities = sortedEntities.subList(0, topCount);
                }
                if (!sortedEntities.isEmpty()) {
                    message.append((Component)Component.literal((String)("\n\nTop " + sortedEntities.size() + " Entity Types:")).withStyle(style -> style.withColor(ChatFormatting.GOLD)));
                    int rank = 1;
                    for (Map.Entry entry : sortedEntities) {
                        EntityType type = (EntityType)entry.getKey();
                        int count = (Integer)entry.getValue();
                        int asyncCount = asyncEntityTypeCounts.getOrDefault(type, 0);
                        ResourceLocation nameID = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type);
                        String name = nameID.toLanguageKey();
                        message.append((Component)Component.literal((String)("\n" + rank + ". ")).withStyle(style -> style.withColor(ChatFormatting.GRAY))).append((Component)Component.literal((String)name).withStyle(style -> style.withColor(ChatFormatting.YELLOW))).append((Component)Component.literal((String)": ").withStyle(style -> style.withColor(ChatFormatting.GRAY))).append((Component)Component.literal((String)String.valueOf(count)).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)" (").withStyle(style -> style.withColor(ChatFormatting.GRAY))).append((Component)Component.literal((String)String.valueOf(asyncCount)).withStyle(style -> style.withColor(ChatFormatting.AQUA))).append((Component)Component.literal((String)" async)").withStyle(style -> style.withColor(ChatFormatting.GRAY)));
                        ++rank;
                    }
                }
            }
            source.sendSuccess(() -> message, true);
        });
    }

    private static double calculateAverageThreads() {
        if (threadSamples.isEmpty()) {
            return 0.0;
        }
        double sum = threadSamples.stream().mapToDouble(Integer::doubleValue).sum();
        return sum / (double)threadSamples.size();
    }

    public static void runStatsThread() {
        if (statsThread != null && statsThread.isAlive()) {
            return;
        }
        statsThread = new Thread(() -> {
            while (isRunning && !Thread.currentThread().isInterrupted()) {
                try {
                    StatsCommand.updateStats();
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Error in stats thread", (Throwable)e);
                }
            }
        }, "Async-Stats-Thread");
        statsThread.setDaemon(true);
        statsThread.start();
    }

    private static void updateStats() {
        if (AsyncConfig.disabled) {
            StatsCommand.resetStats();
            return;
        }
        int currentThreads = ParallelProcessor.currentEntities.get();
        threadSamples.offer(currentThreads);
        while (threadSamples.size() > 100) {
            threadSamples.poll();
        }
    }

    private static void resetStats() {
        threadSamples.clear();
    }

    public static void shutdown() {
        isRunning = false;
        if (statsThread != null) {
            statsThread.interrupt();
        }
    }
}

