/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.server;

import com.axalotl.async.common.ParallelProcessor;
import com.axalotl.async.common.config.AsyncConfig;
import com.axalotl.async.common.parallelised.fastutil.Int2ObjectConcurrentHashMap;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class}, priority=1500)
public abstract class ChunkMapMixin
extends ChunkStorage
implements ChunkHolder.PlayerProvider {
    @Shadow
    @Final
    @Mutable
    private Int2ObjectMap<ChunkMap.TrackedEntity> entityMap;
    @Shadow
    @Final
    @Mutable
    private List<ChunkGenerationTask> pendingGenerationTasks;
    @Shadow
    @Final
    private ChunkMap.DistanceManager distanceManager;
    @Shadow
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap;

    public ChunkMapMixin(RegionStorageInfo regionStorageInfo, Path directory, DataFixer dataFixer, boolean dsync) {
        super(regionStorageInfo, directory, dataFixer, dsync);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void replaceConVars(CallbackInfo ci) {
        this.entityMap = new Int2ObjectConcurrentHashMap<ChunkMap.TrackedEntity>();
        this.pendingGenerationTasks = new CopyOnWriteArrayList<ChunkGenerationTask>();
    }

    @WrapMethod(method={"addEntity"})
    private synchronized void addEntity(Entity entity, Operation<Void> original) {
        original.call(new Object[]{entity});
    }

    @WrapMethod(method={"removeEntity"})
    private synchronized void removeEntity(Entity entity, Operation<Void> original) {
        original.call(new Object[]{entity});
    }

    @WrapMethod(method={"releaseGeneration"})
    private synchronized void releaseGeneration(GenerationChunkHolder chunk, Operation<Void> original) {
        original.call(new Object[]{chunk});
    }

    @Inject(method={"addEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;pauseInIde(Ljava/lang/Throwable;)Ljava/lang/Throwable;")}, cancellable=true)
    private void skipThrowLoadEntity(Entity entity, CallbackInfo ci) {
        ci.cancel();
    }

    @WrapMethod(method={"forEachBlockTickingChunk"})
    private void forEachBlockTickingChunk(Consumer<LevelChunk> action, Operation<Void> original) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncRandomTicks) {
            CompletableFuture.runAsync(() -> original.call(new Object[]{action}), ParallelProcessor.tickPool).exceptionally(e -> {
                ParallelProcessor.LOGGER.error("Error in async random tick, switching to synchronous", e);
                original.call(new Object[]{action});
                return null;
            });
        } else {
            original.call(new Object[]{action});
        }
    }

    @WrapMethod(method={"forEachBlockTickingChunk"})
    private void forEachBlockTicking(Consumer<LevelChunk> action, Operation<Void> original) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncRandomTicks) {
            ArrayList keys = new ArrayList();
            this.distanceManager.forEachEntityTickingChunk(keys::add);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                LevelChunk chunk;
                long chunkPos = (Long)iterator.next();
                ChunkHolder holder = (ChunkHolder)this.visibleChunkMap.get(chunkPos);
                if (holder == null || (chunk = holder.getTickingChunk()) == null) continue;
                action.accept(chunk);
            }
        } else {
            original.call(new Object[]{action});
        }
    }
}

