/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.server;

import com.axalotl.async.common.AsyncCommon;
import com.axalotl.async.common.ParallelProcessor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkCache.class}, priority=1500)
public abstract class ServerChunkCacheMixin
extends ChunkSource {
    @Shadow
    @Final
    public ChunkMap chunkMap;
    @Shadow
    @Final
    Thread mainThread;

    @Shadow
    @Nullable
    public abstract ChunkHolder getVisibleChunkIfPresent(long var1);

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/status/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/ChunkAccess;"}, at={@At(value="HEAD")}, cancellable=true)
    private void shortcutGetChunk(int x, int z, ChunkStatus leastStatus, boolean create, CallbackInfoReturnable<ChunkAccess> cir) {
        CompletableFuture future;
        ChunkHolder holder;
        if (AsyncCommon.LITHIUM) {
            return;
        }
        if (Thread.currentThread() != this.mainThread && (holder = this.getVisibleChunkIfPresent(ChunkPos.asLong((int)x, (int)z))) != null && (future = holder.scheduleChunkGenerationTask(leastStatus, this.chunkMap)).isDone()) {
            ChunkAccess chunk = (ChunkAccess)future.getNow(ChunkHolder.UNLOADED_CHUNK).orElse(null);
            if (chunk instanceof ImposterProtoChunk) {
                ImposterProtoChunk readOnlyChunk = (ImposterProtoChunk)chunk;
                chunk = readOnlyChunk.getWrapped();
            }
            if (chunk != null) {
                cir.setReturnValue((Object)chunk);
                return;
            }
        }
    }

    @Inject(method={"getChunkNow"}, at={@At(value="HEAD")}, cancellable=true)
    private void shortcutGetChunkNow(int chunkX, int chunkZ, CallbackInfoReturnable<LevelChunk> cir) {
        CompletableFuture future;
        ChunkAccess chunk;
        ChunkHolder holder;
        if (Thread.currentThread() != this.mainThread && (holder = this.getVisibleChunkIfPresent(ChunkPos.asLong((int)chunkX, (int)chunkZ))) != null && (chunk = (ChunkAccess)(future = holder.scheduleChunkGenerationTask(ChunkStatus.FULL, this.chunkMap)).getNow(ChunkHolder.UNLOADED_CHUNK).orElse(null)) instanceof LevelChunk) {
            LevelChunk worldChunk = (LevelChunk)chunk;
            cir.setReturnValue((Object)worldChunk);
            return;
        }
    }

    @Redirect(method={"tickSpawningChunk(Lnet/minecraft/world/level/chunk/LevelChunk;JLjava/util/List;Lnet/minecraft/world/level/NaturalSpawner$SpawnState;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/NaturalSpawner;spawnForChunk(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/NaturalSpawner$SpawnState;Ljava/util/List;)V"))
    private void tickSpawningChunk(ServerLevel level, LevelChunk chunk, NaturalSpawner.SpawnState spawnState, List<MobCategory> categories) {
        ParallelProcessor.asyncSpawnForChunk(level, chunk, spawnState, categories);
    }
}

