/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.world;

import com.axalotl.async.common.ParallelProcessor;
import com.axalotl.async.common.parallelised.ConcurrentCollections;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.storage.WritableLevelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class}, priority=1500)
public abstract class ServerLevelMixin
extends Level
implements WorldGenLevel {
    @Shadow
    @Final
    public EntityTickList entityTickList;
    @Unique
    ConcurrentLinkedQueue<BlockEventData> async$syncedBlockEventQueue;
    @Shadow
    @Final
    @Mutable
    Set<Mob> navigatingMobs;
    @Shadow
    @Final
    private ServerChunkCache chunkSource;
    @Shadow
    @Mutable
    @Final
    private List<ServerPlayer> players;
    @Unique
    private static final Object lock = new Object();

    protected ServerLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Shadow
    @NotNull
    public abstract ServerLevel getLevel();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.navigatingMobs = ConcurrentCollections.newHashSet();
        this.async$syncedBlockEventQueue = new ConcurrentLinkedQueue();
        this.players = new CopyOnWriteArrayList<ServerPlayer>();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityTickList;forEach(Ljava/util/function/Consumer;)V"))
    private void overwriteEntityTicking(EntityTickList entityTickList, Consumer<Entity> consumer) {
        ProfilerFiller profilerfiller = Profiler.get();
        this.entityTickList.forEach(entity -> {
            if (!entity.isRemoved() && !this.tickRateManager().isEntityFrozen(entity)) {
                profilerfiller.push("checkDespawn");
                ParallelProcessor.asyncDespawn(entity);
                profilerfiller.pop();
                if (this.chunkSource.chunkMap.getDistanceManager().inEntityTickingRange(entity.chunkPosition().toLong())) {
                    Entity entity2 = entity.getVehicle();
                    if (entity2 != null) {
                        if (!entity2.isRemoved() && entity2.hasPassenger(entity)) {
                            return;
                        }
                        entity.stopRiding();
                    }
                    profilerfiller.push("tick");
                    ParallelProcessor.callEntityTick(this.getLevel(), entity);
                    profilerfiller.pop();
                }
            }
        });
        profilerfiller.push("tick");
        ParallelProcessor.postEntityTick();
        profilerfiller.pop();
    }

    @Redirect(method={"blockEvent"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;add(Ljava/lang/Object;)Z", remap=false))
    private boolean overwriteQueueAdd(ObjectLinkedOpenHashSet<BlockEventData> objectLinkedOpenHashSet, Object object) {
        return this.async$syncedBlockEventQueue.add((BlockEventData)object);
    }

    @Redirect(method={"clearBlockEvents"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;removeIf(Ljava/util/function/Predicate;)Z", remap=false))
    private boolean overwriteQueueRemoveIf(ObjectLinkedOpenHashSet<BlockEventData> objectLinkedOpenHashSet, Predicate<BlockEventData> filter) {
        return this.async$syncedBlockEventQueue.removeIf(filter);
    }

    @Redirect(method={"runBlockEvents"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;isEmpty()Z", remap=false))
    private boolean overwriteEmptyCheck(ObjectLinkedOpenHashSet<BlockEventData> objectLinkedOpenHashSet) {
        return this.async$syncedBlockEventQueue.isEmpty();
    }

    @Redirect(method={"runBlockEvents"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;removeFirst()Ljava/lang/Object;", remap=false))
    private Object overwriteQueueRemoveFirst(ObjectLinkedOpenHashSet<BlockEventData> objectLinkedOpenHashSet) {
        return this.async$syncedBlockEventQueue.poll();
    }

    @Redirect(method={"runBlockEvents"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;addAll(Ljava/util/Collection;)Z", remap=false))
    private boolean overwriteQueueAddAll(ObjectLinkedOpenHashSet<BlockEventData> instance, Collection<? extends BlockEventData> c) {
        return this.async$syncedBlockEventQueue.addAll(c);
    }

    @Redirect(method={"sendBlockUpdated"}, at=@At(value="FIELD", target="Lnet/minecraft/server/level/ServerLevel;isUpdatingNavigations:Z", opcode=181))
    private void skipSendBlockUpdatedCheck(ServerLevel instance, boolean value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"explode"})
    private void createExplosion(@Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, WeightedList<ExplosionParticleInfo> particleInfo, Holder<SoundEvent> explosionSound, Operation<Void> original) {
        Object object = lock;
        synchronized (object) {
            original.call(new Object[]{source, damageSource, damageCalculator, x, y, z, Float.valueOf(radius), fire, explosionInteraction, smallExplosionParticles, largeExplosionParticles, particleInfo, explosionSound});
        }
    }
}

