/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.parallelised.fastutil;

import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public final class FastUtilHackUtil {
    private FastUtilHackUtil() {
        throw new AssertionError((Object)"No instances");
    }

    public static ByteCollection wrapBytes(Collection<Byte> c) {
        return new WrappingByteCollection(c);
    }

    public static ObjectSet<Long2ByteMap.Entry> entrySetLongByteWrap(Map<Long, Byte> map) {
        return new ConvertingObjectSet<Map.Entry, Long2ByteMap.Entry>(map.entrySet(), FastUtilHackUtil::longByteEntryForwards, FastUtilHackUtil::longByteEntryBackwards);
    }

    private static Long2ByteMap.Entry longByteEntryForwards(final Map.Entry<Long, Byte> entry) {
        return new Long2ByteMap.Entry(){

            public byte setValue(byte value) {
                return entry.setValue(value);
            }

            public byte getByteValue() {
                return (Byte)entry.getValue();
            }

            public long getLongKey() {
                return (Long)entry.getKey();
            }

            public boolean equals(Object obj) {
                if (obj == entry) {
                    return true;
                }
                return super.equals(obj);
            }

            public int hashCode() {
                return entry.hashCode();
            }
        };
    }

    private static Map.Entry<Long, Byte> longByteEntryBackwards(Long2ByteMap.Entry entry) {
        return entry;
    }

    public static <T> Long2ObjectMap.FastEntrySet<T> entrySetLongWrapFast(Map<Long, T> map) {
        return new ConvertingObjectSetFast(map.entrySet(), FastUtilHackUtil::longEntryForwards, FastUtilHackUtil::longEntryBackwards);
    }

    public static ByteIterator itrByteWrap(Iterable<Byte> backing) {
        return new WrappingByteIterator(backing.iterator());
    }

    private static <T> Int2ObjectMap.Entry<T> intEntryForwards(final Map.Entry<Integer, T> entry) {
        return new Int2ObjectMap.Entry<T>(){

            public T getValue() {
                return entry.getValue();
            }

            public T setValue(T value) {
                return entry.setValue(value);
            }

            public int getIntKey() {
                return (Integer)entry.getKey();
            }

            public boolean equals(Object obj) {
                if (obj == entry) {
                    return true;
                }
                return super.equals(obj);
            }

            public int hashCode() {
                return entry.hashCode();
            }
        };
    }

    private static <T> Map.Entry<Integer, T> intEntryBackwards(Int2ObjectMap.Entry<T> entry) {
        return entry;
    }

    private static <T> Long2ObjectMap.Entry<T> longEntryForwards(final Map.Entry<Long, T> entry) {
        return new Long2ObjectMap.Entry<T>(){

            public T getValue() {
                return entry.getValue();
            }

            public T setValue(T value) {
                return entry.setValue(value);
            }

            public long getLongKey() {
                return (Long)entry.getKey();
            }

            public boolean equals(Object obj) {
                if (obj == entry) {
                    return true;
                }
                return super.equals(obj);
            }

            public int hashCode() {
                return entry.hashCode();
            }
        };
    }

    private static <T> Map.Entry<Long, T> longEntryBackwards(Long2ObjectMap.Entry<T> entry) {
        return entry;
    }

    public static <T> ObjectSet<Int2ObjectMap.Entry<T>> entrySetIntWrap(Map<Integer, T> map) {
        return new ConvertingObjectSet<Map.Entry, Int2ObjectMap.Entry>(map.entrySet(), FastUtilHackUtil::intEntryForwards, FastUtilHackUtil::intEntryBackwards);
    }

    public static <T> ObjectSet<Long2ObjectMap.Entry<T>> entrySetLongWrap(Map<Long, T> map) {
        return new ConvertingObjectSet<Map.Entry, Long2ObjectMap.Entry>(map.entrySet(), FastUtilHackUtil::longEntryForwards, FastUtilHackUtil::longEntryBackwards);
    }

    public static LongSet wrapLongSet(Set<Long> longset) {
        return new WrappingLongSet(longset);
    }

    public static IntSet wrapIntSet(Set<Integer> intset) {
        return new WrappingIntSet(intset);
    }

    public static ShortIterator itrShortWrap(Iterator<Short> backing) {
        return new WrappingShortIterator(backing);
    }

    public static ShortIterator itrShortWrap(Iterable<Short> backing) {
        return FastUtilHackUtil.itrShortWrap(backing.iterator());
    }

    public static LongListIterator wrap(Iterator<Long> c) {
        return new SlimWrappingLongListIterator(c);
    }

    public static <K> ObjectCollection<K> wrap(Collection<K> c) {
        return new WrappingObjectCollection<K>(c);
    }

    public static <T> ObjectIterator<T> itrWrap(Iterable<T> in) {
        return new WrapperObjectIterator<T>(in.iterator());
    }

    public static class WrappingByteCollection
    implements ByteCollection {
        Collection<Byte> backing;

        public WrappingByteCollection(Collection<Byte> backing) {
            this.backing = backing;
        }

        public int size() {
            return this.backing.size();
        }

        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        public boolean contains(byte o) {
            return this.backing.contains(o);
        }

        public Object @NotNull [] toArray() {
            return this.backing.toArray();
        }

        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            return this.backing.toArray(a);
        }

        public boolean add(byte e) {
            return this.backing.add(e);
        }

        public boolean containsAll(@NotNull Collection<?> c) {
            return this.backing.containsAll(c);
        }

        public boolean addAll(@NotNull Collection<? extends Byte> c) {
            return this.backing.addAll(c);
        }

        public boolean removeAll(@NotNull Collection<?> c) {
            return this.backing.removeAll(c);
        }

        public boolean retainAll(@NotNull Collection<?> c) {
            return this.backing.retainAll(c);
        }

        public void clear() {
            this.backing.clear();
        }

        @NotNull
        public ByteIterator iterator() {
            return FastUtilHackUtil.itrByteWrap(this.backing);
        }

        public boolean rem(byte key) {
            return this.backing.remove(key);
        }

        public byte[] toByteArray() {
            return null;
        }

        public byte[] toArray(byte[] a) {
            return ArrayUtils.toPrimitive((Byte[])this.backing.toArray(new Byte[0]));
        }

        public boolean addAll(ByteCollection c) {
            return this.addAll((Collection<? extends Byte>)c);
        }

        public boolean containsAll(ByteCollection c) {
            return this.containsAll((Collection<?>)c);
        }

        public boolean removeAll(ByteCollection c) {
            return this.removeAll((Collection<?>)c);
        }

        public boolean retainAll(ByteCollection c) {
            return this.retainAll((Collection<?>)c);
        }
    }

    public static class ConvertingObjectSet<E, T>
    implements ObjectSet<T> {
        private final Set<E> backing;
        private final Function<E, T> forward;
        private final Function<T, E> back;

        public ConvertingObjectSet(Set<E> backing, Function<E, T> forward, Function<T, E> back) {
            this.backing = Objects.requireNonNull(backing, "Backing set cannot be null");
            this.forward = Objects.requireNonNull(forward, "Forward function cannot be null");
            this.back = Objects.requireNonNull(back, "Backward function cannot be null");
        }

        public int size() {
            return this.backing.size();
        }

        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        public boolean contains(Object o) {
            try {
                return this.backing.contains(this.back.apply(o));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public Object @NotNull [] toArray() {
            return this.backing.stream().map(this.forward).toArray();
        }

        public <R> R @NotNull [] toArray(R @NotNull [] a) {
            return this.backing.stream().map(this.forward).collect(Collectors.toSet()).toArray(a);
        }

        public boolean add(T e) {
            return this.backing.add(this.back.apply(e));
        }

        public boolean remove(Object o) {
            try {
                return this.backing.remove(this.back.apply(o));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public boolean containsAll(Collection<?> c) {
            try {
                return this.backing.containsAll(c.stream().map(i -> this.back.apply(i)).collect(Collectors.toSet()));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public boolean addAll(Collection<? extends T> c) {
            return this.backing.addAll(c.stream().map(this.back).collect(Collectors.toSet()));
        }

        public boolean removeAll(Collection<?> c) {
            try {
                return this.backing.removeAll(c.stream().map(i -> this.back.apply(i)).collect(Collectors.toSet()));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public boolean retainAll(Collection<?> c) {
            try {
                return this.backing.retainAll(c.stream().map(i -> this.back.apply(i)).collect(Collectors.toSet()));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public void clear() {
            this.backing.clear();
        }

        @NotNull
        public ObjectIterator<T> iterator() {
            return new ObjectIterator<T>(){
                private final Iterator<E> backg;
                {
                    this.backg = backing.iterator();
                }

                public boolean hasNext() {
                    return this.backg.hasNext();
                }

                public T next() {
                    return forward.apply(this.backg.next());
                }

                public void remove() {
                    this.backg.remove();
                }
            };
        }
    }

    public static class ConvertingObjectSetFast<E, T>
    implements Long2ObjectMap.FastEntrySet<T> {
        Set<E> backing;
        Function<E, Long2ObjectMap.Entry<T>> forward;
        Function<Long2ObjectMap.Entry<T>, E> back;

        public ConvertingObjectSetFast(Set<E> backing, Function<E, Long2ObjectMap.Entry<T>> forward, Function<Long2ObjectMap.Entry<T>, E> back) {
            this.backing = backing;
            this.forward = forward;
            this.back = back;
        }

        public int size() {
            return this.backing.size();
        }

        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        public boolean contains(Object o) {
            try {
                return this.backing.contains(this.back.apply((Long2ObjectMap.Entry)o));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public Object @NotNull [] toArray() {
            return this.backing.stream().map(this.forward).toArray();
        }

        public <R> R @NotNull [] toArray(R @NotNull [] a) {
            return this.backing.stream().map(this.forward).collect(Collectors.toSet()).toArray(a);
        }

        public boolean remove(Object o) {
            try {
                return this.backing.remove(this.back.apply((Long2ObjectMap.Entry)o));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public boolean containsAll(Collection<?> c) {
            try {
                return this.backing.containsAll(c.stream().map(i -> this.back.apply((Long2ObjectMap.Entry)i)).collect(Collectors.toSet()));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public boolean removeAll(Collection<?> c) {
            try {
                return this.backing.removeAll(c.stream().map(i -> this.back.apply((Long2ObjectMap.Entry)i)).collect(Collectors.toSet()));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public boolean retainAll(Collection<?> c) {
            try {
                return this.backing.retainAll(c.stream().map(i -> this.back.apply((Long2ObjectMap.Entry)i)).collect(Collectors.toSet()));
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public void clear() {
            this.backing.clear();
        }

        @NotNull
        public ObjectIterator<Long2ObjectMap.Entry<T>> iterator() {
            final Iterator<E> backg = this.backing.iterator();
            return new ObjectIterator<Long2ObjectMap.Entry<T>>(){

                public boolean hasNext() {
                    return backg.hasNext();
                }

                public Long2ObjectMap.Entry<T> next() {
                    return forward.apply(backg.next());
                }

                public void remove() {
                    backg.remove();
                }
            };
        }

        public boolean add(Long2ObjectMap.Entry<T> e) {
            return this.backing.add(this.back.apply(e));
        }

        public boolean addAll(Collection<? extends Long2ObjectMap.Entry<T>> c) {
            return this.backing.addAll(c.stream().map(this.back).toList());
        }

        public ObjectIterator<Long2ObjectMap.Entry<T>> fastIterator() {
            return this.iterator();
        }
    }

    public static class WrappingByteIterator
    implements ByteIterator {
        Iterator<Byte> parent;

        public WrappingByteIterator(Iterator<Byte> parent) {
            this.parent = parent;
        }

        public boolean hasNext() {
            return this.parent.hasNext();
        }

        public void remove() {
            this.parent.remove();
        }

        public byte nextByte() {
            return this.parent.next();
        }
    }

    public static class WrappingLongSet
    implements LongSet {
        private final Set<Long> backing;

        public WrappingLongSet(Set<Long> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public boolean add(long key) {
            return this.backing.add(key);
        }

        public boolean contains(long key) {
            return this.backing.contains(key);
        }

        public long[] toLongArray() {
            return this.backing.stream().mapToLong(Long::longValue).toArray();
        }

        public long[] toArray(long[] a) {
            if (a.length >= this.size()) {
                return null;
            }
            return this.toLongArray();
        }

        public boolean addAll(LongCollection c) {
            return this.backing.addAll((Collection<Long>)c);
        }

        public boolean containsAll(LongCollection c) {
            return this.backing.containsAll((Collection<?>)c);
        }

        public boolean removeAll(LongCollection c) {
            return this.backing.removeAll((Collection<?>)c);
        }

        public boolean retainAll(LongCollection c) {
            return this.backing.retainAll((Collection<?>)c);
        }

        public int size() {
            return this.backing.size();
        }

        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        public Object @NotNull [] toArray() {
            return this.backing.toArray();
        }

        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            return this.backing.toArray(a);
        }

        public boolean containsAll(@NotNull Collection<?> c) {
            return this.backing.containsAll(c);
        }

        public boolean addAll(@NotNull Collection<? extends Long> c) {
            return this.backing.addAll(c);
        }

        public boolean removeAll(@NotNull Collection<?> c) {
            return this.backing.removeAll(c);
        }

        public boolean retainAll(@NotNull Collection<?> c) {
            return this.backing.retainAll(c);
        }

        public void clear() {
            this.backing.clear();
        }

        @NotNull
        public LongIterator iterator() {
            return new WrappingLongIterator(this.backing.iterator());
        }

        public boolean remove(long k) {
            return this.backing.remove(k);
        }
    }

    public static class WrappingIntSet
    implements IntSet {
        private final Set<Integer> backing;

        public WrappingIntSet(Set<Integer> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public boolean add(int key) {
            return this.backing.add(key);
        }

        public boolean contains(int key) {
            return this.backing.contains(key);
        }

        public int[] toIntArray() {
            return this.backing.stream().mapToInt(Integer::intValue).toArray();
        }

        public int[] toArray(int[] a) {
            return ArrayUtils.toPrimitive((Integer[])this.backing.toArray(new Integer[0]));
        }

        public boolean addAll(IntCollection c) {
            return this.backing.addAll((Collection<Integer>)c);
        }

        public boolean containsAll(IntCollection c) {
            return this.backing.containsAll((Collection<?>)c);
        }

        public boolean removeAll(IntCollection c) {
            return this.backing.removeAll((Collection<?>)c);
        }

        public boolean retainAll(IntCollection c) {
            return this.backing.retainAll((Collection<?>)c);
        }

        public int size() {
            return this.backing.size();
        }

        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        public Object @NotNull [] toArray() {
            return this.backing.toArray();
        }

        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            return this.backing.toArray(a);
        }

        public boolean containsAll(@NotNull Collection<?> c) {
            return this.backing.containsAll(c);
        }

        public boolean addAll(@NotNull Collection<? extends Integer> c) {
            return this.backing.addAll(c);
        }

        public boolean removeAll(@NotNull Collection<?> c) {
            return this.backing.removeAll(c);
        }

        public boolean retainAll(@NotNull Collection<?> c) {
            return this.backing.retainAll(c);
        }

        public void clear() {
            this.backing.clear();
        }

        @NotNull
        public IntIterator iterator() {
            return new WrappingIntIterator(this.backing.iterator());
        }

        public boolean remove(int k) {
            return this.backing.remove(k);
        }
    }

    static class WrappingShortIterator
    implements ShortIterator {
        private final Iterator<Short> backing;

        WrappingShortIterator(Iterator<Short> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public boolean hasNext() {
            return this.backing.hasNext();
        }

        public short nextShort() {
            return this.backing.next();
        }

        public void remove() {
            this.backing.remove();
        }
    }

    public static class SlimWrappingLongListIterator
    implements LongListIterator {
        private final Iterator<Long> backing;

        SlimWrappingLongListIterator(Iterator<Long> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public long previousLong() {
            throw new UnsupportedOperationException();
        }

        public long nextLong() {
            return this.backing.next();
        }

        public boolean hasNext() {
            return this.backing.hasNext();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            this.backing.remove();
        }
    }

    public static class WrappingObjectCollection<V>
    implements ObjectCollection<V> {
        private final Collection<V> backing;

        public WrappingObjectCollection(Collection<V> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public int size() {
            return this.backing.size();
        }

        public boolean isEmpty() {
            return this.backing.isEmpty();
        }

        public boolean contains(Object o) {
            return this.backing.contains(o);
        }

        public Object @NotNull [] toArray() {
            return this.backing.toArray();
        }

        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            return this.backing.toArray(a);
        }

        public boolean add(V e) {
            return this.backing.add(e);
        }

        public boolean remove(Object o) {
            return this.backing.remove(o);
        }

        public boolean containsAll(@NotNull Collection<?> c) {
            return this.backing.containsAll(c);
        }

        public boolean addAll(@NotNull Collection<? extends V> c) {
            return this.backing.addAll(c);
        }

        public boolean removeAll(@NotNull Collection<?> c) {
            return this.backing.removeAll(c);
        }

        public boolean retainAll(@NotNull Collection<?> c) {
            return this.backing.retainAll(c);
        }

        public void clear() {
            this.backing.clear();
        }

        @NotNull
        public ObjectIterator<V> iterator() {
            return FastUtilHackUtil.itrWrap(this.backing);
        }
    }

    private record WrapperObjectIterator<T>(Iterator<T> parent) implements ObjectIterator<T>
    {
        private WrapperObjectIterator(Iterator<T> parent) {
            this.parent = Objects.requireNonNull(parent);
        }

        public boolean hasNext() {
            return this.parent.hasNext();
        }

        public T next() {
            return this.parent.next();
        }

        public void remove() {
            this.parent.remove();
        }
    }

    static class WrappingLongIterator
    implements LongIterator {
        private final Iterator<Long> backing;

        WrappingLongIterator(Iterator<Long> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public boolean hasNext() {
            return this.backing.hasNext();
        }

        public long nextLong() {
            return this.backing.next();
        }

        public void remove() {
            this.backing.remove();
        }
    }

    static class WrappingIntIterator
    implements IntIterator {
        private final Iterator<Integer> backing;

        WrappingIntIterator(Iterator<Integer> backing) {
            this.backing = Objects.requireNonNull(backing);
        }

        public boolean hasNext() {
            return this.backing.hasNext();
        }

        public int nextInt() {
            return this.backing.next();
        }

        public void remove() {
            this.backing.remove();
        }
    }
}

