/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.parallelised.fastutil;

import com.axalotl.async.common.parallelised.fastutil.FastUtilHackUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class Int2ObjectConcurrentHashMap<V>
implements Int2ObjectMap<V> {
    private final ConcurrentHashMap<Integer, V> backing = new ConcurrentHashMap(16, 0.9f, 1);
    private V defaultReturnValue;

    public V get(int key) {
        return this.backing.getOrDefault(key, this.defaultReturnValue);
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    public void putAll(@NotNull Map<? extends Integer, ? extends V> m) {
        this.backing.putAll(Objects.requireNonNull(m, "Source map cannot be null"));
    }

    public int size() {
        return this.backing.size();
    }

    public void defaultReturnValue(V rv) {
        this.defaultReturnValue = rv;
    }

    public V defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public ObjectSet<Int2ObjectMap.Entry<V>> int2ObjectEntrySet() {
        return FastUtilHackUtil.entrySetIntWrap(this.backing);
    }

    @NotNull
    public IntSet keySet() {
        return FastUtilHackUtil.wrapIntSet(this.backing.keySet());
    }

    @NotNull
    public ObjectCollection<V> values() {
        return FastUtilHackUtil.wrap(this.backing.values());
    }

    public boolean containsKey(int key) {
        return this.backing.containsKey(key);
    }

    public V put(int key, V value) {
        return this.backing.put(key, value);
    }

    public V remove(int key) {
        return this.backing.remove(key);
    }

    public void clear() {
        this.backing.clear();
    }

    public V compute(int key, BiFunction<? super Integer, ? super V, ? extends V> remappingFunction) {
        return this.backing.compute(key, Objects.requireNonNull(remappingFunction));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Int2ObjectMap)) {
            return false;
        }
        Int2ObjectMap that = (Int2ObjectMap)o;
        return this.size() == that.size() && this.int2ObjectEntrySet().containsAll((Collection)that.int2ObjectEntrySet());
    }

    public int hashCode() {
        return this.backing.hashCode();
    }

    public String toString() {
        return this.backing.toString();
    }

    public V getOrDefault(int key, V defaultValue) {
        return this.backing.getOrDefault(key, defaultValue);
    }

    public V putIfAbsent(int key, V value) {
        return this.backing.putIfAbsent(key, value);
    }

    public boolean remove(int key, Object value) {
        V previous = this.backing.remove(key);
        return this.backing.remove(key, previous);
    }

    public boolean replace(int key, V oldValue, V newValue) {
        return this.backing.replace(key, oldValue, newValue);
    }

    public V replace(int key, V value) {
        return this.backing.replace(key, value);
    }
}

