/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.config;

import com.axalotl.async.common.platform.PlatformEvents;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConfig {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Async Config");
    public static boolean disabled = false;
    public static int paraMax = -1;
    public static boolean enableAsyncSpawn = true;
    public static boolean enableAsyncRandomTicks = false;
    public static Set<ResourceLocation> synchronizedEntities = AsyncConfig.getDefaultSynchronizedEntities();

    public static Set<ResourceLocation> getDefaultSynchronizedEntities() {
        return Set.of(Objects.requireNonNull(ResourceLocation.tryBuild((String)"minecraft", (String)"tnt")), Objects.requireNonNull(ResourceLocation.tryBuild((String)"minecraft", (String)"item")), Objects.requireNonNull(ResourceLocation.tryBuild((String)"minecraft", (String)"experience_orb")));
    }

    public static int getParallelism() {
        if (paraMax <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), paraMax));
    }

    public static void syncEntity(ResourceLocation entityId) {
        if (synchronizedEntities.add(entityId)) {
            PlatformEvents.getInstance().saveConfig();
            LOGGER.info("Sync entity class: {}", (Object)entityId);
        } else {
            LOGGER.warn("Entity class already synchronized: {}", (Object)entityId);
        }
    }

    public static void asyncEntity(ResourceLocation entityId) {
        if (synchronizedEntities.remove(entityId)) {
            PlatformEvents.getInstance().saveConfig();
            LOGGER.info("Enable async process entity class: {}", (Object)entityId);
        } else {
            LOGGER.warn("Entity class not found: {}", (Object)entityId);
        }
    }
}

