/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1001)
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = new ConcurrentHashMap<Holder<MobEffect>, MobEffectInstance>();
    @Unique
    private static final Object async$lock = new Object();

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapMethod(method={"die"})
    private synchronized void die(DamageSource damageSource, Operation<Void> original) {
        original.call(new Object[]{damageSource});
    }

    @WrapMethod(method={"dropFromLootTable(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;Z)V"})
    private synchronized void dropFromLootTable(ServerLevel level, DamageSource damageSource, boolean playerKill, Operation<Void> original) {
        original.call(new Object[]{level, damageSource, playerKill});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"knockback"})
    private synchronized void knockback(double strength, double x, double z, Operation<Void> original) {
        Object object = async$lock;
        synchronized (object) {
            original.call(new Object[]{strength, x, z});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"tickEffects"})
    private void tickStatusEffects(Operation<Void> original) {
        Object object = async$lock;
        synchronized (object) {
            original.call(new Object[0]);
        }
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;tickServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/Runnable;)Z")})
    private boolean wrapTickEffect(MobEffectInstance instance, ServerLevel level, LivingEntity entity, Runnable onEffectUpdated, Operation<Boolean> original) {
        if (instance != null) {
            return (Boolean)original.call(new Object[]{instance, level, entity, onEffectUpdated});
        }
        return false;
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="INVOKE", target="Ljava/util/List;of(Ljava/lang/Object;)Ljava/util/List;")})
    private List<?> wrapListOf(Object element, Operation<List<?>> original) {
        if (element == null) {
            return Collections.emptyList();
        }
        return (List)original.call(new Object[]{element});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"})
    private boolean addEffect(MobEffectInstance effect, Entity source, Operation<Boolean> original) {
        Object object = async$lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[]{effect, source});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"removeEffect"})
    private boolean removeEffect(Holder<MobEffect> effect, Operation<Boolean> original) {
        Object object = async$lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[]{effect});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"removeAllEffects"})
    private boolean removeAllEffects(Operation<Boolean> original) {
        Object object = async$lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[0]);
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(double fallDistance, float multiplier, DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        BlockPos pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getY()), Mth.floor((double)this.getZ()));
        BlockState currentBlock = this.level().getBlockState(pos);
        if (currentBlock.is(BlockTags.CLIMBABLE)) {
            cir.setReturnValue((Object)false);
        }
    }
}

