/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.neoforge.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AsyncConfig {
    public static final ModConfigSpec SPEC;
    private static final ModConfigSpec.Builder BUILDER;
    private static final ModConfigSpec.ConfigValue<Boolean> disabled;
    private static final ModConfigSpec.ConfigValue<Integer> paraMax;
    private static final ModConfigSpec.ConfigValue<List<String>> synchronizedEntities;
    private static final ModConfigSpec.ConfigValue<Boolean> enableAsyncSpawn;
    private static final ModConfigSpec.ConfigValue<Boolean> enableAsyncRandomTicks;

    public static void loadConfig() {
        com.axalotl.async.common.config.AsyncConfig.disabled = (Boolean)disabled.get();
        com.axalotl.async.common.config.AsyncConfig.paraMax = (Integer)paraMax.get();
        com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn = (Boolean)enableAsyncSpawn.get();
        com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks = (Boolean)enableAsyncRandomTicks.get();
        com.axalotl.async.common.config.AsyncConfig.synchronizedEntities = new HashSet<ResourceLocation>();
        List ids = (List)synchronizedEntities.get();
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String id : ids) {
            ResourceLocation rl = ResourceLocation.tryParse((String)id);
            if (rl == null) continue;
            set.add(rl);
        }
        com.axalotl.async.common.config.AsyncConfig.synchronizedEntities = set.isEmpty() ? com.axalotl.async.common.config.AsyncConfig.getDefaultSynchronizedEntities() : set;
    }

    public static void saveConfig() {
        disabled.set((Object)com.axalotl.async.common.config.AsyncConfig.disabled);
        paraMax.set((Object)com.axalotl.async.common.config.AsyncConfig.paraMax);
        enableAsyncSpawn.set((Object)com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn);
        enableAsyncRandomTicks.set((Object)com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks);
        synchronizedEntities.set(new ArrayList<String>(com.axalotl.async.common.config.AsyncConfig.synchronizedEntities.stream().map(ResourceLocation::toString).toList()));
        SPEC.save();
        com.axalotl.async.common.config.AsyncConfig.LOGGER.info("Configuration successfully saved.");
    }

    static {
        BUILDER = new ModConfigSpec.Builder();
        BUILDER.push("Async Config");
        disabled = BUILDER.comment("Enables parallel processing of entity.").define("disabled", com.axalotl.async.common.config.AsyncConfig.disabled);
        paraMax = BUILDER.comment("Maximum number of threads to use for parallel processing. Set to -1 to use default value.").define("paraMax", (Object)com.axalotl.async.common.config.AsyncConfig.paraMax);
        synchronizedEntities = BUILDER.comment("List of entity class for sync processing.").define("synchronizedEntities", new ArrayList<String>(com.axalotl.async.common.config.AsyncConfig.synchronizedEntities.stream().map(ResourceLocation::toString).toList()));
        enableAsyncSpawn = BUILDER.comment("Enables parallel processing of entity spawns.").define("enableAsyncSpawn", com.axalotl.async.common.config.AsyncConfig.enableAsyncSpawn);
        enableAsyncRandomTicks = BUILDER.comment("Experimental! Enables async processing of random ticks.").define("enableAsyncRandomTicks", com.axalotl.async.common.config.AsyncConfig.enableAsyncRandomTicks);
        BUILDER.pop();
        SPEC = BUILDER.build();
        com.axalotl.async.common.config.AsyncConfig.LOGGER.info("Configuration successfully loaded.");
    }
}

