/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common;

import com.axalotl.async.common.config.AsyncConfig;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1540;
import net.minecraft.class_1606;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1948;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelProcessor {
    public static final Logger LOGGER = LogManager.getLogger(ParallelProcessor.class);
    private static MinecraftServer server;
    public static final AtomicInteger currentEntities;
    private static final AtomicInteger threadPoolID;
    public static ExecutorService tickPool;
    private static final BlockingQueue<CompletableFuture<?>> taskQueue;
    private static final Set<UUID> blacklistedEntity;
    private static final Map<UUID, Integer> portalTickSyncMap;
    private static final Map<String, Set<WeakReference<Thread>>> mcThreadTracker;
    public static final Set<Class<?>> BLOCKED_ENTITIES;

    public static void setupThreadPool(int parallelism, Class<?> asyncClass) {
        ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("Async-Tick-Pool-Thread-" + threadPoolID.getAndIncrement());
            ParallelProcessor.registerThread("Async-Tick", worker);
            worker.setDaemon(true);
            worker.setPriority(5);
            worker.setContextClassLoader(asyncClass.getClassLoader());
            return worker;
        };
        tickPool = new ForkJoinPool(parallelism, threadFactory, (t, e) -> LOGGER.error("Uncaught exception in thread {}: {}", (Object)t.getName(), (Object)e), true);
        LOGGER.info("Initialized Pool with {} threads", (Object)parallelism);
    }

    public static void registerThread(String poolName, Thread thread) {
        mcThreadTracker.computeIfAbsent(poolName, key -> ConcurrentHashMap.newKeySet()).add(new WeakReference<Thread>(thread));
    }

    private static boolean isThreadInPool(Thread thread) {
        return mcThreadTracker.getOrDefault("Async-Tick", Set.of()).stream().map(Reference::get).anyMatch(thread::equals);
    }

    public static boolean isServerExecutionThread() {
        return ParallelProcessor.isThreadInPool(Thread.currentThread());
    }

    public static void callEntityTick(class_3218 world, class_1297 entity) {
        if (ParallelProcessor.shouldTickSynchronously(entity)) {
            ParallelProcessor.tickSynchronously(world, entity);
        } else if (!tickPool.isShutdown() && !tickPool.isTerminated()) {
            CompletionStage future = CompletableFuture.runAsync(() -> ParallelProcessor.performAsyncEntityTick(world, entity), tickPool).exceptionally(e -> {
                ParallelProcessor.logEntityError("Error in async tick, switching to synchronous", entity, e);
                ParallelProcessor.tickSynchronously(world, entity);
                blacklistedEntity.add(entity.method_5667());
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            ParallelProcessor.logEntityError("Rejected task due to ExecutorService shutdown", entity, null);
            ParallelProcessor.tickSynchronously(world, entity);
        }
    }

    public static boolean shouldTickSynchronously(class_1297 entity) {
        boolean requiresSyncTick;
        if (entity.method_73183().method_8608()) {
            return true;
        }
        UUID entityId = entity.method_5667();
        boolean bl = requiresSyncTick = AsyncConfig.disabled || entity instanceof class_1676 || entity instanceof class_1688 || entity instanceof class_3222 || BLOCKED_ENTITIES.contains(entity.getClass()) || blacklistedEntity.contains(entityId) || AsyncConfig.synchronizedEntities.contains(class_1299.method_5890((class_1299)entity.method_5864()));
        if (requiresSyncTick) {
            return true;
        }
        if (portalTickSyncMap.containsKey(entityId)) {
            int ticksLeft = portalTickSyncMap.get(entityId);
            if (ticksLeft > 0) {
                portalTickSyncMap.put(entityId, ticksLeft - 1);
                return true;
            }
            portalTickSyncMap.remove(entityId);
        }
        if (ParallelProcessor.isPortalTickRequired(entity)) {
            portalTickSyncMap.put(entityId, 39);
            return true;
        }
        return false;
    }

    private static boolean isPortalTickRequired(class_1297 entity) {
        return entity.field_51994 != null && entity.field_51994.method_60709();
    }

    private static void tickSynchronously(class_3218 world, class_1297 entity) {
        try {
            world.method_18762(entity);
        }
        catch (Exception e) {
            ParallelProcessor.logEntityError("Error during synchronous tick", entity, e);
        }
    }

    private static void performAsyncEntityTick(class_3218 world, class_1297 entity) {
        currentEntities.incrementAndGet();
        try {
            world.method_18762(entity);
        }
        finally {
            currentEntities.decrementAndGet();
        }
    }

    public static void asyncSpawnForChunk(class_3218 level, class_2818 chunk, class_1948.class_5262 spawnState, List<class_1311> categories) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncSpawn) {
            CompletionStage future = CompletableFuture.runAsync(() -> class_1948.method_27821((class_3218)level, (class_2818)chunk, (class_1948.class_5262)spawnState, (List)categories), tickPool).exceptionally(e -> {
                LOGGER.error("Error in async spawn, switching to synchronous", e);
                class_1948.method_27821((class_3218)level, (class_2818)chunk, (class_1948.class_5262)spawnState, (List)categories);
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            class_1948.method_27821((class_3218)level, (class_2818)chunk, (class_1948.class_5262)spawnState, categories);
        }
    }

    public static void asyncDespawn(class_1297 entity) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncSpawn) {
            CompletionStage future = CompletableFuture.runAsync(() -> ((class_1297)entity).method_5982(), tickPool).exceptionally(e -> {
                LOGGER.error("Error in async spawn tick, switching to synchronous", e);
                entity.method_5982();
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            entity.method_5982();
        }
    }

    public static void postEntityTick() {
        CompletableFuture future;
        if (AsyncConfig.disabled) {
            return;
        }
        ArrayList<CompletableFuture> futuresList = new ArrayList<CompletableFuture>();
        while ((future = (CompletableFuture)taskQueue.poll()) != null) {
            futuresList.add(future);
        }
        CompletableFuture<Void> allTasks = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
        allTasks.exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            LOGGER.error("Error during entity tick processing: ", cause);
            return null;
        });
        while (!allTasks.isDone()) {
            boolean hasTask = false;
            for (class_3218 world2 : server.method_3738()) {
                hasTask |= world2.method_14178().method_19492();
            }
            if (hasTask) continue;
            LockSupport.parkNanos(50000L);
        }
        server.method_3738().forEach(world -> {
            world.method_14178().method_19492();
            world.method_14178().field_18809.method_18857(allTasks::isDone);
        });
    }

    public static void stop() {
        if (tickPool != null) {
            LOGGER.info("Waiting for Async tickPool to shutdown...");
            tickPool.shutdown();
            try {
                tickPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void logEntityError(String message, class_1297 entity, Throwable e) {
        LOGGER.error("{} Entity Type: {}, UUID: {}", (Object)message, (Object)entity.method_5864().toString(), (Object)entity.method_5667(), (Object)e);
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        ParallelProcessor.server = server;
    }

    static {
        currentEntities = new AtomicInteger();
        threadPoolID = new AtomicInteger();
        taskQueue = new LinkedBlockingQueue();
        blacklistedEntity = ConcurrentHashMap.newKeySet();
        portalTickSyncMap = new ConcurrentHashMap<UUID, Integer>();
        mcThreadTracker = new ConcurrentHashMap<String, Set<WeakReference<Thread>>>();
        BLOCKED_ENTITIES = Set.of(class_1540.class, class_1606.class, class_1690.class);
    }
}

