/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.server;

import com.axalotl.async.common.ParallelProcessor;
import com.axalotl.async.common.config.AsyncConfig;
import com.axalotl.async.common.parallelised.fastutil.Int2ObjectConcurrentHashMap;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3898;
import net.minecraft.class_3977;
import net.minecraft.class_9240;
import net.minecraft.class_9759;
import net.minecraft.class_9761;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3898.class}, priority=1500)
public abstract class ChunkMapMixin
extends class_3977
implements class_3193.class_3897 {
    @Shadow
    @Final
    @Mutable
    private Int2ObjectMap<class_3898.class_3208> field_18242;
    @Shadow
    @Final
    @Mutable
    private List<class_9759> field_51864;
    @Shadow
    @Final
    private class_3898.class_3216 field_17228;
    @Shadow
    private volatile Long2ObjectLinkedOpenHashMap<class_3193> field_17220;

    public ChunkMapMixin(class_9240 regionStorageInfo, Path directory, DataFixer dataFixer, boolean dsync) {
        super(regionStorageInfo, directory, dataFixer, dsync);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void replaceConVars(CallbackInfo ci) {
        this.field_18242 = new Int2ObjectConcurrentHashMap<class_3898.class_3208>();
        this.field_51864 = new CopyOnWriteArrayList<class_9759>();
    }

    @WrapMethod(method={"addEntity"})
    private synchronized void addEntity(class_1297 entity, Operation<Void> original) {
        original.call(new Object[]{entity});
    }

    @WrapMethod(method={"removeEntity"})
    private synchronized void removeEntity(class_1297 entity, Operation<Void> original) {
        original.call(new Object[]{entity});
    }

    @WrapMethod(method={"releaseGeneration"})
    private synchronized void releaseGeneration(class_9761 chunk, Operation<Void> original) {
        original.call(new Object[]{chunk});
    }

    @Inject(method={"addEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;pauseInIde(Ljava/lang/Throwable;)Ljava/lang/Throwable;")}, cancellable=true)
    private void skipThrowLoadEntity(class_1297 entity, CallbackInfo ci) {
        ci.cancel();
    }

    @WrapMethod(method={"forEachBlockTickingChunk"})
    private void forEachBlockTickingChunk(Consumer<class_2818> action, Operation<Void> original) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncRandomTicks) {
            CompletableFuture.runAsync(() -> original.call(new Object[]{action}), ParallelProcessor.tickPool).exceptionally(e -> {
                ParallelProcessor.LOGGER.error("Error in async random tick, switching to synchronous", e);
                original.call(new Object[]{action});
                return null;
            });
        } else {
            original.call(new Object[]{action});
        }
    }

    @WrapMethod(method={"forEachBlockTickingChunk"})
    private void forEachBlockTicking(Consumer<class_2818> action, Operation<Void> original) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncRandomTicks) {
            ArrayList keys = new ArrayList();
            this.field_17228.method_67500(keys::add);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                class_2818 chunk;
                long chunkPos = (Long)iterator.next();
                class_3193 holder = (class_3193)this.field_17220.get(chunkPos);
                if (holder == null || (chunk = holder.method_16144()) == null) continue;
                action.accept(chunk);
            }
        } else {
            original.call(new Object[]{action});
        }
    }
}

