/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.fabric;

import com.axalotl.async.common.ParallelProcessor;
import com.axalotl.async.common.commands.AsyncCommand;
import com.axalotl.async.common.commands.StatsCommand;
import com.axalotl.async.fabric.config.AsyncConfig;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncFabric
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger(AsyncFabric.class);
    public static boolean LITHIUM = FabricLoader.getInstance().isModLoaded("lithium");
    public static boolean VMP = FabricLoader.getInstance().isModLoaded("vmp");

    public void onInitialize() {
        LOGGER.info("Initializing Async...");
        AsyncConfig.init();
        StatsCommand.runStatsThread();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            LOGGER.info("Async Setting up thread-pool...");
            ParallelProcessor.setServer(server);
            ParallelProcessor.setupThreadPool(com.axalotl.async.common.config.AsyncConfig.getParallelism(), this.getClass());
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> AsyncCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            StatsCommand.shutdown();
            ParallelProcessor.stop();
        });
        LOGGER.info("Async Initialized Successfully!");
    }
}

