/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.fabric.mixin.utils;

import com.axalotl.async.fabric.AsyncFabric;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class SynchronisePlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int FINAL_STATIC_PRIVATE_ABSTRACT = 5448;
    private static final int SYNCHRONIZED = 32;
    private final Multimap<String, String> mixin2MethodsMap = ArrayListMultimap.create();
    private final Multimap<String, String> mixin2MethodsExcludeMap = ArrayListMultimap.create();
    private final TreeSet<String> syncAllSet = new TreeSet();

    public void onLoad(String mixinPackage) {
        this.mixin2MethodsExcludeMap.put((Object)"com.axalotl.async.common.mixin.utils.SyncAllMixin", (Object)"net.minecraft.world.level.chunk.ChunkStatus.isOrAfter");
        this.syncAllSet.add("com.axalotl.async.common.mixin.utils.FastUtilsMixin");
        this.syncAllSet.add("com.axalotl.async.common.mixin.utils.SyncAllMixin");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.endsWith("com.axalotl.async.common.mixin.lithium.LithiumServerChunkCacheMixin") || mixinClassName.endsWith("com.axalotl.async.common.mixin.lithium.LithiumServerLevel")) {
            return AsyncFabric.LITHIUM;
        }
        if (mixinClassName.endsWith("com.axalotl.async.common.mixin.vmp.VMPChunkMapMixin")) {
            return AsyncFabric.VMP;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        Collection targetMethods = this.mixin2MethodsMap.get((Object)mixinClassName);
        Collection excludedMethods = this.mixin2MethodsExcludeMap.get((Object)mixinClassName);
        if (!targetMethods.isEmpty()) {
            this.applySynchronizeBit(targetClass, targetMethods, targetClassName);
        } else if (this.syncAllSet.contains(mixinClassName)) {
            for (MethodNode method : targetClass.methods) {
                if ((method.access & 0x1548) != 0 || method.name.equals("<init>") || excludedMethods.contains(method.name)) continue;
                method.access |= 0x20;
                this.logSynchronize(method.name, targetClassName, mixinClassName);
            }
        }
    }

    private void applySynchronizeBit(ClassNode targetClass, Collection<String> targetMethods, String targetClassName) {
        for (MethodNode method : targetClass.methods) {
            for (String targetMethod : targetMethods) {
                if (!method.name.equals(targetMethod)) continue;
                method.access |= 0x20;
                this.logSynchronize(method.name, targetClassName, null);
            }
        }
    }

    private void logSynchronize(String methodName, String targetClassName, String mixinClassName) {
        if (mixinClassName == null || !mixinClassName.equals("com.axalotl.async.mixin.utils.FastUtilsMixin")) {
            String message = "Setting synchronize bit for " + methodName + " in " + targetClassName + ".";
            LOGGER.debug(message);
        }
    }
}

