/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common;

import com.axalotl.async.common.config.AsyncConfig;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelProcessor {
    public static final Logger LOGGER = LogManager.getLogger(ParallelProcessor.class);
    private static MinecraftServer server;
    public static final AtomicInteger currentEntities;
    private static final AtomicInteger threadPoolID;
    public static ExecutorService tickPool;
    private static final BlockingQueue<CompletableFuture<?>> taskQueue;
    private static final Set<UUID> blacklistedEntity;
    private static final Map<UUID, Integer> portalTickSyncMap;
    private static final Map<String, Set<WeakReference<Thread>>> mcThreadTracker;
    public static final Set<Class<?>> BLOCKED_ENTITIES;

    public static void setupThreadPool(int parallelism, Class<?> asyncClass) {
        ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("Async-Tick-Pool-Thread-" + threadPoolID.getAndIncrement());
            ParallelProcessor.registerThread("Async-Tick", worker);
            worker.setDaemon(true);
            worker.setPriority(5);
            worker.setContextClassLoader(asyncClass.getClassLoader());
            return worker;
        };
        tickPool = new ForkJoinPool(parallelism, threadFactory, (t, e) -> LOGGER.error("Uncaught exception in thread {}: {}", (Object)t.getName(), (Object)e), true);
        LOGGER.info("Initialized Pool with {} threads", (Object)parallelism);
    }

    public static void registerThread(String poolName, Thread thread) {
        mcThreadTracker.computeIfAbsent(poolName, key -> ConcurrentHashMap.newKeySet()).add(new WeakReference<Thread>(thread));
    }

    private static boolean isThreadInPool(Thread thread) {
        return mcThreadTracker.getOrDefault("Async-Tick", Set.of()).stream().map(Reference::get).anyMatch(thread::equals);
    }

    public static boolean isServerExecutionThread() {
        return ParallelProcessor.isThreadInPool(Thread.currentThread());
    }

    public static void callEntityTick(ServerLevel world, Entity entity) {
        if (ParallelProcessor.shouldTickSynchronously(entity)) {
            ParallelProcessor.tickSynchronously(world, entity);
        } else if (!tickPool.isShutdown() && !tickPool.isTerminated()) {
            CompletionStage future = CompletableFuture.runAsync(() -> ParallelProcessor.performAsyncEntityTick(world, entity), tickPool).exceptionally(e -> {
                ParallelProcessor.logEntityError("Error in async tick, switching to synchronous", entity, e);
                ParallelProcessor.tickSynchronously(world, entity);
                blacklistedEntity.add(entity.getUUID());
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            ParallelProcessor.logEntityError("Rejected task due to ExecutorService shutdown", entity, null);
            ParallelProcessor.tickSynchronously(world, entity);
        }
    }

    public static boolean shouldTickSynchronously(Entity entity) {
        boolean requiresSyncTick;
        if (entity.level().isClientSide()) {
            return true;
        }
        UUID entityId = entity.getUUID();
        boolean bl = requiresSyncTick = AsyncConfig.disabled || entity instanceof Projectile || entity instanceof AbstractMinecart || entity instanceof ServerPlayer || BLOCKED_ENTITIES.contains(entity.getClass()) || blacklistedEntity.contains(entityId) || AsyncConfig.synchronizedEntities.contains(EntityType.getKey((EntityType)entity.getType()));
        if (requiresSyncTick) {
            return true;
        }
        if (portalTickSyncMap.containsKey(entityId)) {
            int ticksLeft = portalTickSyncMap.get(entityId);
            if (ticksLeft > 0) {
                portalTickSyncMap.put(entityId, ticksLeft - 1);
                return true;
            }
            portalTickSyncMap.remove(entityId);
        }
        if (ParallelProcessor.isPortalTickRequired(entity)) {
            portalTickSyncMap.put(entityId, 39);
            return true;
        }
        return false;
    }

    private static boolean isPortalTickRequired(Entity entity) {
        return entity.portalProcess != null && entity.portalProcess.isInsidePortalThisTick();
    }

    private static void tickSynchronously(ServerLevel world, Entity entity) {
        try {
            world.tickNonPassenger(entity);
        }
        catch (Exception e) {
            ParallelProcessor.logEntityError("Error during synchronous tick", entity, e);
        }
    }

    private static void performAsyncEntityTick(ServerLevel world, Entity entity) {
        currentEntities.incrementAndGet();
        try {
            world.tickNonPassenger(entity);
        }
        finally {
            currentEntities.decrementAndGet();
        }
    }

    public static void asyncSpawnForChunk(ServerLevel level, LevelChunk chunk, NaturalSpawner.SpawnState spawnState, boolean spawnFriendlies, boolean spawnMonsters, boolean forcedDespawn) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncSpawn) {
            CompletionStage future = CompletableFuture.runAsync(() -> NaturalSpawner.spawnForChunk((ServerLevel)level, (LevelChunk)chunk, (NaturalSpawner.SpawnState)spawnState, (boolean)spawnFriendlies, (boolean)spawnMonsters, (boolean)forcedDespawn), tickPool).exceptionally(e -> {
                LOGGER.error("Error in async spawn, switching to synchronous", e);
                NaturalSpawner.spawnForChunk((ServerLevel)level, (LevelChunk)chunk, (NaturalSpawner.SpawnState)spawnState, (boolean)spawnFriendlies, (boolean)spawnMonsters, (boolean)forcedDespawn);
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            NaturalSpawner.spawnForChunk((ServerLevel)level, (LevelChunk)chunk, (NaturalSpawner.SpawnState)spawnState, (boolean)spawnFriendlies, (boolean)spawnMonsters, (boolean)forcedDespawn);
        }
    }

    public static void asyncDespawn(Entity entity) {
        if (!AsyncConfig.disabled && AsyncConfig.enableAsyncSpawn) {
            CompletionStage future = CompletableFuture.runAsync(() -> ((Entity)entity).checkDespawn(), tickPool).exceptionally(e -> {
                LOGGER.error("Error in async spawn tick, switching to synchronous", e);
                entity.checkDespawn();
                return null;
            });
            taskQueue.add((CompletableFuture<?>)future);
        } else {
            entity.checkDespawn();
        }
    }

    public static void postEntityTick() {
        if (AsyncConfig.disabled) {
            return;
        }
        ArrayList futuresList = new ArrayList();
        taskQueue.drainTo(futuresList);
        CompletableFuture<Void> allTasks = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
        allTasks.exceptionally(ex -> {
            Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
            LOGGER.error("Error during entity tick processing: ", cause);
            return null;
        });
        while (!allTasks.isDone()) {
            boolean hasTask = false;
            for (ServerLevel world2 : server.getAllLevels()) {
                hasTask |= world2.getChunkSource().pollTask();
            }
            if (hasTask) continue;
            LockSupport.parkNanos(1000000L);
        }
        server.getAllLevels().forEach(world -> {
            world.getChunkSource().pollTask();
            world.getChunkSource().mainThreadProcessor.managedBlock(allTasks::isDone);
        });
    }

    public static void stop() {
        if (tickPool != null && !tickPool.isShutdown()) {
            tickPool.shutdown();
        }
    }

    private static void logEntityError(String message, Entity entity, Throwable e) {
        LOGGER.error("{} Entity Type: {}, UUID: {}", (Object)message, (Object)entity.getType().toString(), (Object)entity.getUUID(), (Object)e);
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        ParallelProcessor.server = server;
    }

    static {
        currentEntities = new AtomicInteger();
        threadPoolID = new AtomicInteger();
        taskQueue = new LinkedBlockingQueue();
        blacklistedEntity = ConcurrentHashMap.newKeySet();
        portalTickSyncMap = new ConcurrentHashMap<UUID, Integer>();
        mcThreadTracker = new ConcurrentHashMap<String, Set<WeakReference<Thread>>>();
        BLOCKED_ENTITIES = Set.of(FallingBlockEntity.class, Shulker.class, Boat.class);
    }
}

