/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.commands;

import com.axalotl.async.common.commands.AsyncCommand;
import com.axalotl.async.common.config.AsyncConfig;
import com.axalotl.async.common.platform.PlatformEvents;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ConfigCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> registerConfig(LiteralArgumentBuilder<CommandSourceStack> root) {
        return (LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").then(((LiteralArgumentBuilder)Commands.literal((String)"toggle").requires(cmdSrc -> cmdSrc.hasPermission(4))).executes(cmdCtx -> {
            AsyncConfig.disabled = !AsyncConfig.disabled;
            PlatformEvents.getInstance().saveConfig();
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Async is now ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)(AsyncConfig.disabled ? "disabled" : "enabled")).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"synchronizedEntities").requires(cmdSrc -> cmdSrc.hasPermission(4))).executes(cmdCtx -> {
            Set<ResourceLocation> currentValue = AsyncConfig.synchronizedEntities;
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Synchronized Entities: ").withStyle(style -> style.withColor(ChatFormatting.WHITE)));
            if (currentValue.isEmpty()) {
                message.append((Component)Component.literal((String)"No entities synchronized.").withStyle(style -> style.withColor(ChatFormatting.RED)));
            } else {
                message.append((Component)Component.literal((String)"\n").withStyle(style -> style.withColor(ChatFormatting.WHITE)));
                for (ResourceLocation entity : currentValue) {
                    message.append((Component)Component.literal((String)"- ").withStyle(style -> style.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)entity.toString()).withStyle(style -> style.withColor(ChatFormatting.YELLOW))).append((Component)Component.literal((String)"\n"));
                }
            }
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, false);
            return 1;
        })).then(Commands.literal((String)"add").then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(cmdCtx -> {
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)cmdCtx, (String)"entity");
            if (AsyncConfig.synchronizedEntities.contains(id)) {
                MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Error entity class ").withStyle(style -> style.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)id.toString()).withStyle(style -> style.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)" is already synchronized.").withStyle(style -> style.withColor(ChatFormatting.RED)));
                ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
                return 1;
            }
            AsyncConfig.syncEntity(id);
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Entity class ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)id.toString()).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)" has been added to the synchronized list.").withStyle(style -> style.withColor(ChatFormatting.WHITE)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
            return 1;
        })))).then(Commands.literal((String)"remove").then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            AsyncConfig.synchronizedEntities.forEach(id -> builder.suggest(id.toString()));
            return builder.buildFuture();
        }).executes(cmdCtx -> {
            ResourceLocation identifier = (ResourceLocation)cmdCtx.getArgument("entity", ResourceLocation.class);
            if (!AsyncConfig.synchronizedEntities.contains(identifier)) {
                MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Error entity class ").withStyle(style -> style.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)identifier.toString()).withStyle(style -> style.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)" is not in the synchronized list.").withStyle(style -> style.withColor(ChatFormatting.RED)));
                ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
                return 1;
            }
            AsyncConfig.asyncEntity(identifier);
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Entity class ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)identifier.toString()).withStyle(style -> style.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)" has been removed from synchronized list.").withStyle(style -> style.withColor(ChatFormatting.WHITE)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setAsyncEntitySpawn").requires(cmdSrc -> cmdSrc.hasPermission(4))).executes(cmdCtx -> {
            boolean currentValue = AsyncConfig.enableAsyncSpawn;
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Current value of async entity spawn: ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)String.valueOf(currentValue)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(cmdCtx -> {
            boolean value;
            AsyncConfig.enableAsyncSpawn = value = BoolArgumentType.getBool((CommandContext)cmdCtx, (String)"value");
            PlatformEvents.getInstance().saveConfig();
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Async Entity Spawn set to ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)String.valueOf(value)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setAsyncRandomTicks").requires(cmdSrc -> cmdSrc.hasPermission(4))).executes(cmdCtx -> {
            boolean currentValue = AsyncConfig.enableAsyncRandomTicks;
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Current value of async random ticks: ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)String.valueOf(currentValue)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(cmdCtx -> {
            boolean value;
            AsyncConfig.enableAsyncRandomTicks = value = BoolArgumentType.getBool((CommandContext)cmdCtx, (String)"value");
            PlatformEvents.getInstance().saveConfig();
            MutableComponent message = AsyncCommand.prefix.copy().append((Component)Component.literal((String)"Async Random Ticks set to ").withStyle(style -> style.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)String.valueOf(value)).withStyle(style -> style.withColor(ChatFormatting.GREEN)));
            ((CommandSourceStack)cmdCtx.getSource()).sendSuccess(() -> message, true);
            return 1;
        }))));
    }
}

