/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, priority=1001)
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = new ConcurrentHashMap<Holder<MobEffect>, MobEffectInstance>();
    @Unique
    private static final Object async$lock = new Object();

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapMethod(method={"die"})
    private synchronized void die(DamageSource damageSource, Operation<Void> original) {
        original.call(new Object[]{damageSource});
    }

    @WrapMethod(method={"dropFromLootTable"})
    private synchronized void dropFromLootTable(DamageSource damageSource, boolean causedByPlayer, Operation<Void> original) {
        original.call(new Object[]{damageSource, causedByPlayer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"blockedByShield"})
    private synchronized void knockback(LivingEntity defender, Operation<Void> original) {
        Object object = async$lock;
        synchronized (object) {
            original.call(new Object[]{defender});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"tickEffects"})
    private void tickStatusEffects(Operation<Void> original) {
        Object object = async$lock;
        synchronized (object) {
            original.call(new Object[0]);
        }
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;tick(Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/Runnable;)Z")})
    private boolean tickEffects(MobEffectInstance instance, LivingEntity entity, Runnable runnable, Operation<Boolean> original) {
        if (instance != null) {
            return (Boolean)original.call(new Object[]{instance, entity, runnable});
        }
        return false;
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEffectRemoved(MobEffectInstance effectInstance, CallbackInfo ci) {
        if (effectInstance == null) {
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"})
    private boolean addEffect(MobEffectInstance effect, Entity source, Operation<Boolean> original) {
        Object object = async$lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[]{effect, source});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"removeEffect"})
    private boolean removeEffect(Holder<MobEffect> effect, Operation<Boolean> original) {
        Object object = async$lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[]{effect});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"removeAllEffects"})
    private boolean removeAllEffects(Operation<Boolean> original) {
        Object object = async$lock;
        synchronized (object) {
            return (Boolean)original.call(new Object[0]);
        }
    }
}

