/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.mixin.lithium;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.caffeinemc.mods.lithium.common.world.chunk.ChunkHolderExtended;
import net.caffeinemc.mods.lithium.mixin.world.chunk_access.GenerationChunkHolderAccessor;
import net.minecraft.Util;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public abstract class LithiumServerChunkCacheMixin
extends ChunkSource {
    @Shadow
    @Final
    public ServerChunkCache.MainThreadExecutor mainThreadProcessor;
    @Shadow
    @Final
    private DistanceManager distanceManager;
    @Shadow
    @Final
    public ChunkMap chunkMap;
    @Shadow
    @Final
    Thread mainThread;
    @Unique
    private long async$time;
    @Unique
    private final long[] async$cacheKeys = new long[4];
    @Unique
    private final ChunkAccess[] async$cacheChunks = new ChunkAccess[4];

    @Shadow
    public abstract ChunkHolder getVisibleChunkIfPresent(long var1);

    @Shadow
    protected abstract boolean chunkAbsent(ChunkHolder var1, int var2);

    @Shadow
    public abstract void tick(@NotNull BooleanSupplier var1, boolean var2);

    @Shadow
    abstract boolean runDistanceManagerUpdates();

    @Shadow
    public abstract <T> void removeRegionTicket(TicketType<T> var1, ChunkPos var2, int var3, T var4);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void preTick(BooleanSupplier shouldKeepTicking, boolean tickChunks, CallbackInfo ci) {
        ++this.async$time;
    }

    @Overwrite
    @Nullable
    public ChunkAccess getChunk(int x, int z, @NotNull ChunkStatus status, boolean create) {
        if (Thread.currentThread() != this.mainThread) {
            return this.async$getChunkOffThread(x, z, status, create);
        }
        long key = LithiumServerChunkCacheMixin.async$createCacheKey(x, z, status);
        for (int i = 0; i < 4; ++i) {
            ChunkAccess chunk;
            if (key != this.async$cacheKeys[i] || (chunk = this.async$cacheChunks[i]) == null && create) continue;
            return chunk;
        }
        ChunkAccess chunk = this.async$getChunkBlocking(x, z, status, create);
        if (chunk != null) {
            this.async$addToCache(key, chunk);
        } else if (create) {
            throw new IllegalStateException("Chunk not there when requested");
        }
        return chunk;
    }

    @Unique
    private ChunkAccess async$getChunkOffThread(int x, int z, ChunkStatus status, boolean create) {
        ChunkAccess ifPresent;
        long pos = ChunkPos.asLong((int)x, (int)z);
        ChunkHolder holder = this.getVisibleChunkIfPresent(pos);
        ChunkAccess chunkAccess = ifPresent = holder == null ? null : holder.getChunkIfPresent(status);
        if (ifPresent != null) {
            if (ifPresent instanceof ImposterProtoChunk) {
                ImposterProtoChunk proto = (ImposterProtoChunk)ifPresent;
                return proto.getWrapped();
            }
            return ifPresent;
        }
        return create ? this.async$syncLoad(x, z, status) : null;
    }

    @Unique
    private ChunkAccess async$syncLoad(int chunkX, int chunkZ, ChunkStatus status) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        CompletableFuture future = new CompletableFuture();
        this.mainThreadProcessor.execute(() -> {
            this.distanceManager.addTicket(TicketType.FORCED, chunkPos, ChunkLevel.byStatus((ChunkStatus)status), (Object)chunkPos);
            this.runDistanceManagerUpdates();
            ChunkHolder holder = this.getVisibleChunkIfPresent(chunkPos.toLong());
            if (holder == null) {
                this.removeRegionTicket(TicketType.UNKNOWN, chunkPos, 0, chunkPos);
                future.completeExceptionally(new IllegalStateException("ChunkHolder is null"));
                return;
            }
            holder.scheduleChunkGenerationTask(status, this.chunkMap).whenCompleteAsync((optChunk, throwable) -> {
                this.removeRegionTicket(TicketType.UNKNOWN, chunkPos, 0, chunkPos);
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                    return;
                }
                ChunkAccess chunk = (ChunkAccess)optChunk.orElse(null);
                if (chunk instanceof ImposterProtoChunk) {
                    ImposterProtoChunk readOnlyChunk = (ImposterProtoChunk)chunk;
                    chunk = readOnlyChunk.getWrapped();
                }
                if (chunk == null) {
                    future.completeExceptionally(new IllegalStateException("Chunk not loaded when requested"));
                } else {
                    future.complete(chunk);
                }
            }, (Executor)this.mainThreadProcessor);
        });
        return (ChunkAccess)future.join();
    }

    @Unique
    private ChunkAccess async$getChunkBlocking(int x, int z, ChunkStatus leastStatus, boolean create) {
        ChunkAccess chunk;
        CompletableFuture directlyAccessedFuture;
        long key = ChunkPos.asLong((int)x, (int)z);
        int level = ChunkLevel.byStatus((ChunkStatus)leastStatus);
        ChunkHolder holder = this.getVisibleChunkIfPresent(key);
        if (this.chunkAbsent(holder, level)) {
            if (!create) {
                return null;
            }
            this.async$createChunkLoadTicket(x, z, level);
            this.runDistanceManagerUpdates();
            holder = this.getVisibleChunkIfPresent(key);
            if (this.chunkAbsent(holder, level)) {
                throw (IllegalStateException)Util.pauseInIde((Throwable)new IllegalStateException("No chunk holder after ticket has been added"));
            }
        } else if (create && ((ChunkHolderExtended)holder).lithium$updateLastAccessTime(this.async$time)) {
            this.async$createChunkLoadTicket(x, z, level);
        }
        if (!((GenerationChunkHolderAccessor)holder).invokeCannotBeLoaded(leastStatus) && (directlyAccessedFuture = (CompletableFuture)((GenerationChunkHolderAccessor)holder).lithium$getChunkFuturesByStatus().get(leastStatus.getIndex())) != null && directlyAccessedFuture.isDone() && (chunk = (ChunkAccess)((ChunkResult)directlyAccessedFuture.join()).orElse(null)) != null) {
            return chunk;
        }
        CompletableFuture loadFuture = holder.scheduleChunkGenerationTask(leastStatus, this.chunkMap);
        if (!loadFuture.isDone()) {
            ServerChunkCache.MainThreadExecutor var10000 = this.mainThreadProcessor;
            Objects.requireNonNull(loadFuture);
            var10000.managedBlock(loadFuture::isDone);
        }
        return (ChunkAccess)((ChunkResult)loadFuture.join()).orElse(null);
    }

    @Unique
    private void async$createChunkLoadTicket(int x, int z, int level) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.distanceManager.addTicket(TicketType.UNKNOWN, chunkPos, level, (Object)chunkPos);
    }

    @Unique
    private static long async$createCacheKey(int chunkX, int chunkZ, ChunkStatus status) {
        return (long)chunkX & 0xFFFFFFFL | ((long)chunkZ & 0xFFFFFFFL) << 28 | (long)status.getIndex() << 56;
    }

    @Unique
    private void async$addToCache(long key, ChunkAccess chunk) {
        for (int i = 3; i > 0; --i) {
            this.async$cacheKeys[i] = this.async$cacheKeys[i - 1];
            this.async$cacheChunks[i] = this.async$cacheChunks[i - 1];
        }
        this.async$cacheKeys[0] = key;
        this.async$cacheChunks[0] = chunk;
    }

    @Inject(method={"clearCache()V"}, at={@At(value="HEAD")})
    private void onCachesCleared(CallbackInfo ci) {
        Arrays.fill(this.async$cacheKeys, Long.MAX_VALUE);
        Arrays.fill(this.async$cacheChunks, null);
    }
}

