/*
 * Decompiled with CFR 0.152.
 */
package com.axalotl.async.common.parallelised.fastutil;

import com.axalotl.async.common.parallelised.fastutil.FastUtilHackUtil;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentLongSortedSet
implements LongSortedSet {
    private final ConcurrentSkipListSet<Long> backing = new ConcurrentSkipListSet();

    public ConcurrentLongSortedSet() {
    }

    public ConcurrentLongSortedSet(Collection<Long> collection) {
        this();
        this.addAll(Objects.requireNonNull(collection, "Initial collection cannot be null"));
    }

    public LongBidirectionalIterator iterator(long fromElement) {
        return FastUtilHackUtil.wrap(this.backing.tailSet((Object)fromElement).iterator());
    }

    @NotNull
    public LongBidirectionalIterator iterator() {
        return FastUtilHackUtil.wrap(this.backing.iterator());
    }

    public int size() {
        return this.backing.size();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.backing.toArray();
    }

    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] array) {
        return this.backing.toArray(array);
    }

    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.backing.containsAll(collection);
    }

    public boolean addAll(@NotNull Collection<? extends Long> collection) {
        return this.backing.addAll(collection);
    }

    public boolean removeAll(@NotNull Collection<?> collection) {
        return this.backing.removeAll(collection);
    }

    public boolean retainAll(@NotNull Collection<?> collection) {
        return this.backing.retainAll(collection);
    }

    public void clear() {
        this.backing.clear();
    }

    public boolean add(long key) {
        return this.backing.add(key);
    }

    public boolean contains(long key) {
        return this.backing.contains(key);
    }

    public long[] toLongArray() {
        return this.longStream().toArray();
    }

    public long[] toArray(long[] array) {
        long[] result = this.toLongArray();
        if (array.length < result.length) {
            return result;
        }
        System.arraycopy(result, 0, array, 0, result.length);
        if (array.length > result.length) {
            array[result.length] = 0L;
        }
        return array;
    }

    public boolean addAll(LongCollection c) {
        boolean modified = false;
        LongIterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.backing.add(it.nextLong())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean containsAll(LongCollection c) {
        LongIterator it = c.iterator();
        while (it.hasNext()) {
            if (this.backing.contains(it.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(LongCollection c) {
        boolean modified = false;
        LongIterator it = c.iterator();
        while (it.hasNext()) {
            if (!this.backing.remove(it.nextLong())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(LongCollection c) {
        return this.backing.retainAll((Collection<?>)c);
    }

    public boolean remove(long k) {
        return this.backing.remove(k);
    }

    public LongSortedSet subSet(long fromElement, long toElement) {
        return new ConcurrentLongSortedSet(this.backing.subSet((Object)Math.min(fromElement, toElement), (Object)Math.max(fromElement, toElement)));
    }

    public LongSortedSet headSet(long toElement) {
        return new ConcurrentLongSortedSet(this.backing.headSet((Object)toElement));
    }

    public LongSortedSet tailSet(long fromElement) {
        return new ConcurrentLongSortedSet(this.backing.tailSet((Object)fromElement));
    }

    public LongComparator comparator() {
        return null;
    }

    public long firstLong() {
        return this.backing.first();
    }

    public long lastLong() {
        return this.backing.last();
    }

    public boolean equals(Object o) {
        LongSortedSet that;
        return this == o || o instanceof LongSortedSet && this.backing.equals(that = (LongSortedSet)o);
    }

    public int hashCode() {
        return this.backing.hashCode();
    }

    public String toString() {
        return this.backing.toString();
    }
}

