/*
 * Decompiled with CFR 0.152.
 */
package pkgbadges.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import pkgbadges.init.PkgbadgesModItems;
import pkgbadges.network.CraftHandler;
import pkgbadges.network.PokeFashionCraft;
import pkgbadges.world.inventory.PokeFashionWorkshopGUIMenu;

public class PokeFashionWorkshopGUIScreen
extends AbstractContainerScreen<PokeFashionWorkshopGUIMenu> {
    private static final HashMap<String, Object> guistate = PokeFashionWorkshopGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private float rotationAngle = 0.0f;
    private long lastCraftTime = 0L;
    private static final long COOLDOWN_PERIOD_MS = 4000L;
    private final List<Item> backpackItems = Arrays.asList((Item)PkgbadgesModItems.TRAINER_BACKPACK.get(), (Item)PkgbadgesModItems.TRAINER_BACKPACK_GREEN.get(), (Item)PkgbadgesModItems.TRAINER_BACKPACK_ORANGE.get(), (Item)PkgbadgesModItems.TRAINER_BACKPACK_PINK.get(), (Item)PkgbadgesModItems.MISTYS_BACKPACK.get(), (Item)PkgbadgesModItems.BROCKS_BACKPACK.get(), (Item)PkgbadgesModItems.BONNIE_WAIST_BAG.get(), (Item)PkgbadgesModItems.SERENA_BACKPACK.get(), (Item)PkgbadgesModItems.ASH_KETCHUMS_BACKPACK.get(), (Item)PkgbadgesModItems.CHARMANDER_BACKPACK.get(), (Item)PkgbadgesModItems.GENGAR_BACKPACK.get());
    private final List<Item> hatItems = Arrays.asList((Item)PkgbadgesModItems.ASH_KETCHUM_INDIGO_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_JOHTO_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KECHUM_SINNOH_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_HOENN_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_UNOVA_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_KALOS_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_ALOLA_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_GALAR_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.PIKACHU_HAT.get(), (Item)PkgbadgesModItems.BULBASAUR_HAT.get(), (Item)PkgbadgesModItems.EEVEE_HAT.get(), (Item)PkgbadgesModItems.SQUIRTLE_HAT.get(), (Item)PkgbadgesModItems.SNORLAX_HAT.get(), (Item)PkgbadgesModItems.LEON_HAT.get(), (Item)PkgbadgesModItems.FRIEDE_GLASSES.get(), (Item)PkgbadgesModItems.CAPTAIN_HAT.get(), (Item)PkgbadgesModItems.SERENA_HAT.get(), (Item)PkgbadgesModItems.SERENA_HAT_GALAR.get(), (Item)PkgbadgesModItems.WORKER_HARD_HAT.get(), (Item)PkgbadgesModItems.ALIANS_SCRAF.get(), (Item)PkgbadgesModItems.KORRINA_BIKE_HELMET.get(), (Item)PkgbadgesModItems.ROCKET_TEAM_HAT.get(), (Item)PkgbadgesModItems.POLICE_HAT.get(), (Item)PkgbadgesModItems.NURSE_JOY_HAT.get(), (Item)PkgbadgesModItems.CHARMANDER_RACER_HELMET.get(), (Item)PkgbadgesModItems.SQUIRTLE_RACER_HELMET.get(), (Item)PkgbadgesModItems.JIGGLYPUFF_RACER_HELMET.get(), (Item)PkgbadgesModItems.PIKACHU_RACER_HELMET.get(), (Item)PkgbadgesModItems.MEOWTH_RACER_HELMET.get(), (Item)PkgbadgesModItems.EEVEE_RACER_HELMET.get(), (Item)PkgbadgesModItems.GASTLY_RACER_HELMET.get(), (Item)PkgbadgesModItems.BULBASAUR_RACER_HELMET.get());
    private final List<Item> outfitItems = Arrays.asList((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_BOOTS.get(), (Item)PkgbadgesModItems.GARY_OAK_CLOTH.get(), (Item)PkgbadgesModItems.GARY_OAK_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.GARY_OAK_CLOTH_BOOTS.get(), (Item)PkgbadgesModItems.FRIEDE.get(), (Item)PkgbadgesModItems.FRIEDE_LEGGINGS.get(), (Item)PkgbadgesModItems.FRIEDE_BOOTS.get(), (Item)PkgbadgesModItems.STEVEN_STONE.get(), (Item)PkgbadgesModItems.STEVEN_STONE_LEGGINGS.get(), (Item)PkgbadgesModItems.STEVEN_STONE_BOOTS.get(), (Item)PkgbadgesModItems.ORLA.get(), (Item)PkgbadgesModItems.ORLA_LEGGINGS.get(), (Item)PkgbadgesModItems.ORLA_BOOTS.get());
    private int currentItemIndex = 0;
    private List<Item> currentCategoryItems = this.backpackItems;
    ImageButton imagebutton_poke_fashion_workshop_gui_denext;
    ImageButton imagebutton_poke_fashion_workshop_gui_next;
    ImageButton imagebutton_poke_fashion_workshop_gui_assemb;
    private static final ResourceLocation texture = new ResourceLocation("pkgbadges:textures/screens/pokefashion_workshop_gui.png");

    public PokeFashionWorkshopGUIScreen(PokeFashionWorkshopGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.f_97726_ = 256;
        this.f_97727_ = 191;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(texture, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        RenderSystem.disableBlend();
    }

    public boolean m_7933_(int key, int b, int c) {
        if (key == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(key, b, c);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    private void render3DModel(GuiGraphics guiGraphics, int x, int y, int scale, float rotationX, float rotationY, float rotationZ) {
        if (this.currentItemIndex < 0 || this.currentItemIndex >= this.currentCategoryItems.size()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)this.currentCategoryItems.get(this.currentItemIndex));
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280168_().m_85836_();
            if (this.currentCategoryItems == this.backpackItems) {
                guiGraphics.m_280168_().m_252880_(85.0f, 93.0f, 100.0f);
            } else if (this.currentCategoryItems == this.hatItems) {
                guiGraphics.m_280168_().m_252880_(85.0f, 125.0f, 100.0f);
            } else if (this.currentCategoryItems == this.outfitItems) {
                guiGraphics.m_280168_().m_252880_(85.0f, 90.0f, 100.0f);
            }
            guiGraphics.m_280168_().m_85841_((float)scale, (float)scale, (float)scale);
            guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(rotationX));
            guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(this.rotationAngle));
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            Minecraft minecraft = Minecraft.m_91087_();
            EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
            MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
            String armorTexture = this.getArmorTexture(armorItem, armorItem.m_40402_());
            HumanoidModel model = new HumanoidModel(minecraft.m_167973_().m_171103_(ModelLayers.f_171164_));
            ArmorStand armorStand = new ArmorStand((Level)minecraft.f_91073_, 0.0, 0.0, 0.0);
            armorStand.m_8061_(armorItem.m_40402_(), stack);
            armorStand.m_6842_(true);
            armorStand.m_31678_(true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation(armorTexture));
            entityRenderDispatcher.m_114384_((Entity)armorStand, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0);
            bufferSource.m_109911_();
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
        this.rotationAngle += 1.0f;
        if (this.rotationAngle >= 360.0f) {
            this.rotationAngle = 0.0f;
        }
    }

    private String getArmorTexture(ArmorItem armorItem, EquipmentSlot slot) {
        String materialName = armorItem.m_40401_().m_6082_();
        String texture = "minecraft:textures/models/armor/" + materialName + "_layer_" + (slot == EquipmentSlot.LEGS ? 2 : 1) + ".png";
        return texture;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.entity == null || this.entity.m_150109_() == null) {
            return;
        }
        Item selectedItem = this.currentCategoryItems.get(this.currentItemIndex);
        List<ItemStack> materials = this.getRequiredMaterials(selectedItem);
        this.render3DModel(guiGraphics, this.f_97735_ + 180, this.f_97736_ + 110, 40, 0.0f, 0.0f, 0.0f);
        int xPos = 192;
        int yPos = 65;
        float scale = 0.6f;
        for (ItemStack material : materials) {
            if (material.m_41619_()) continue;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            int itemCountInInventory = this.getItemCountInInventory(material);
            boolean hasMaterial = itemCountInInventory >= material.m_41613_();
            int color = hasMaterial ? 65280 : 0xFF0000;
            MutableComponent materialText = Component.m_237113_((String)(itemCountInInventory + "/" + material.m_41613_() + " " + (material.m_41786_() != null ? material.m_41786_().getString() : "Unknown Item")));
            if (this.f_96547_ != null) {
                guiGraphics.m_280614_(this.f_96547_, (Component)materialText, (int)((float)xPos / scale), (int)((float)yPos / scale), color, false);
            }
            yPos += 18;
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private int getItemCountInInventory(ItemStack material) {
        if (material.m_41619_()) {
            return 0;
        }
        int count = 0;
        for (ItemStack itemStack : this.entity.m_150109_().f_35974_) {
            if (itemStack.m_41619_() || !itemStack.m_150930_(material.m_41720_())) continue;
            count += itemStack.m_41613_();
        }
        return count;
    }

    private void selectCategory(String category) {
        switch (category) {
            case "backpack": {
                this.currentCategoryItems = this.backpackItems;
                break;
            }
            case "hat": {
                this.currentCategoryItems = this.hatItems;
                break;
            }
            case "clothes": {
                this.currentCategoryItems = this.outfitItems;
            }
        }
        this.currentItemIndex = 0;
        this.updateSelectedItem();
    }

    private void updateSelectedItem() {
        Item selectedItem = this.currentCategoryItems.get(this.currentItemIndex);
    }

    private List<ItemStack> getRequiredMaterials(Item item) {
        HashMap<Item, List<ItemStack>> materialMap = new HashMap<Item, List<ItemStack>>();
        materialMap.put((Item)PkgbadgesModItems.GENGAR_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)Items.f_42009_, 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 10), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6)));
        materialMap.put((Item)PkgbadgesModItems.CHARMANDER_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)Items.f_42009_, 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUMS_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 3), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.SERENA_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.BONNIE_WAIST_BAG.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.BROCKS_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 12), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.MISTYS_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK_ORANGE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK_PINK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK_GREEN.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42009_, 1)));
        materialMap.put((Item)PkgbadgesModItems.ORLA.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.ORLA_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 6)));
        materialMap.put((Item)PkgbadgesModItems.ORLA_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.STEVEN_STONE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 10), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.STEVEN_STONE_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.STEVEN_STONE_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_GLASSES.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 2), new ItemStack((ItemLike)Items.f_42587_, 4)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.GARY_OAK_CLOTH.get(), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)Items.f_41912_, 1), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.GARY_OAK_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.GARY_OAK_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_INDIGO_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 1)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_JOHTO_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 1)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KECHUM_SINNOH_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 5), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_HOENN_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 5), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_UNOVA_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_KALOS_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_ALOLA_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_GALAR_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.SERENA_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.TRILBY_HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42401_, 2)));
        materialMap.put((Item)PkgbadgesModItems.SERENA_HAT_GALAR.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.TRILBY_HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42401_, 2)));
        materialMap.put((Item)PkgbadgesModItems.LEON_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 16)));
        materialMap.put((Item)PkgbadgesModItems.JIGGLYPUFF_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.SQUIRTLE_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.CHARMANDER_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.EEVEE_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.MEOWTH_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.BULBASAUR_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.PIKACHU_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.GASTLY_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.f_42027_, 1), new ItemStack((ItemLike)Items.f_41913_, 1)));
        materialMap.put((Item)PkgbadgesModItems.SQUIRTLE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.CYAN_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.EEVEE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.BULBASAUR_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.SNORLAX_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.CYAN_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 13)));
        materialMap.put((Item)PkgbadgesModItems.PIKACHU_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.NURSE_JOY_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.POLICE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 1)));
        materialMap.put((Item)PkgbadgesModItems.ROCKET_TEAM_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.CAPTAIN_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ALIANS_SCRAF.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.CYAN_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.KORRINA_BIKE_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)Items.f_42416_, 3), new ItemStack((ItemLike)Items.f_42401_, 2)));
        materialMap.put((Item)PkgbadgesModItems.WORKER_HARD_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)Items.f_42416_, 8), new ItemStack((ItemLike)Items.f_42539_, 4)));
        if (materialMap.containsKey(item)) {
            return (List)materialMap.get(item);
        }
        return Collections.emptyList();
    }

    private boolean hasRequiredMaterials(Item item) {
        List<ItemStack> requiredMaterials = this.getRequiredMaterials(item);
        for (ItemStack material : requiredMaterials) {
            int requiredAmount = material.m_41613_();
            int availableAmount = 0;
            for (ItemStack stack : this.entity.m_150109_().f_35974_) {
                if (stack.m_41720_() != material.m_41720_()) continue;
                availableAmount += stack.m_41613_();
            }
            if (availableAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private void removeMaterials(Item item) {
        List<ItemStack> requiredMaterials = this.getRequiredMaterials(item);
        for (ItemStack material : requiredMaterials) {
            int count = material.m_41613_();
            for (int i = 0; i < this.entity.m_150109_().m_6643_() && count > 0; ++i) {
                ItemStack stackInSlot = this.entity.m_150109_().m_8020_(i);
                if (stackInSlot.m_41720_() != material.m_41720_()) continue;
                int removeCount = Math.min(stackInSlot.m_41613_(), count);
                stackInSlot.m_41774_(removeCount);
                count -= removeCount;
            }
        }
    }

    private int findItemInInventory(Item item) {
        for (int i = 0; i < this.entity.m_150109_().m_6643_(); ++i) {
            ItemStack stack = this.entity.m_150109_().m_8020_(i);
            if (stack.m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    private void craftItem(Item item) {
        if (this.isInputSlotEmpty()) {
            return;
        }
        if (this.hasRequiredMaterials(item)) {
            this.removeMaterials(item);
            this.giveCraftedItem(item);
        }
    }

    private void giveCraftedItem(Item item) {
        ItemStack craftedItemStack = new ItemStack((ItemLike)item);
        if (!this.entity.m_150109_().m_36054_(craftedItemStack)) {
            this.entity.m_7197_(craftedItemStack, false, true);
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"Inventory full! Crafted item dropped on ground."), false);
        } else {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("Crafted " + craftedItemStack.m_41786_().getString() + "!")), false);
        }
    }

    private void attemptCraftItem() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCraftTime < 4000L) {
            return;
        }
        if (this.isInputSlotEmpty()) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"No coal!"), false);
            return;
        }
        CraftHandler.INSTANCE.sendToServer((Object)new PokeFashionCraft(this.currentItemIndex, this.getCurrentCategory()));
        this.lastCraftTime = currentTime;
        this.playCraftingSound();
    }

    private void playCraftingSound() {
        try {
            String[] soundNames = new String[]{"sewing", "sewing_v2"};
            String selectedSound = soundNames[(int)(Math.random() * (double)soundNames.length)];
            ResourceLocation soundLocation = new ResourceLocation("pkgbadges", selectedSound);
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundLocation);
            if (soundEvent != null) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvent, (float)1.0f));
            } else {
                System.out.println("Sound event not found: " + soundLocation);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        catch (Exception e) {
            System.out.println("Error playing sound: " + e.getMessage());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    private boolean isInputSlotEmpty() {
        ItemStack inputSlotStack = ((PokeFashionWorkshopGUIMenu)this.f_97732_).m_38853_(0).m_7993_();
        return inputSlotStack.m_41619_();
    }

    private String getCurrentCategory() {
        if (this.currentCategoryItems == this.backpackItems) {
            return "backpack";
        }
        if (this.currentCategoryItems == this.hatItems) {
            return "hat";
        }
        if (this.currentCategoryItems == this.outfitItems) {
            return "clothes";
        }
        return "backpack";
    }

    public void m_7856_() {
        super.m_7856_();
        this.imagebutton_poke_fashion_workshop_gui_denext = new ImageButton(this.f_97735_ + 11, this.f_97736_ + 22, 10, 11, 0, 0, 0, new ResourceLocation("pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_denext.png"), 10, 22, e -> {
            if (this.currentItemIndex > 0) {
                --this.currentItemIndex;
                this.updateSelectedItem();
            }
        });
        guistate.put("button:imagebutton_poke_fashion_workshop_gui_denext", this.imagebutton_poke_fashion_workshop_gui_denext);
        this.m_142416_((GuiEventListener)this.imagebutton_poke_fashion_workshop_gui_denext);
        this.imagebutton_poke_fashion_workshop_gui_next = new ImageButton(this.f_97735_ + 158, this.f_97736_ + 22, 10, 11, 0, 0, 0, new ResourceLocation("pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_next.png"), 10, 22, e -> {
            if (this.currentItemIndex < this.currentCategoryItems.size() - 1) {
                ++this.currentItemIndex;
                this.updateSelectedItem();
            }
        });
        guistate.put("button:imagebutton_poke_fashion_workshop_gui_next", this.imagebutton_poke_fashion_workshop_gui_next);
        this.m_142416_((GuiEventListener)this.imagebutton_poke_fashion_workshop_gui_next);
        this.imagebutton_poke_fashion_workshop_gui_assemb = new ImageButton(this.f_97735_ + 187, this.f_97736_ + 36, 67, 12, 0, 0, 0, new ResourceLocation("pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_assemb.png"), 67, 24, e -> this.attemptCraftItem());
        guistate.put("button:imagebutton_poke_fashion_workshop_gui_assemb", this.imagebutton_poke_fashion_workshop_gui_assemb);
        this.m_142416_((GuiEventListener)this.imagebutton_poke_fashion_workshop_gui_assemb);
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 19, this.f_97736_ + -17, 22, 20, 0, 0, 0, new ResourceLocation("pkgbadges:textures/screens/poke_fashion_workshop_gui_backpack.png"), 22, 19, e -> this.selectCategory("backpack")));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 51, this.f_97736_ + -17, 22, 20, 0, 0, 0, new ResourceLocation("pkgbadges:textures/screens/poke_fashion_workshop_gui_hat.png"), 22, 19, e -> this.selectCategory("hat")));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 85, this.f_97736_ + -17, 22, 20, 0, 0, 0, new ResourceLocation("pkgbadges:textures/screens/poke_fashion_workshop_gui_cloth.png"), 22, 19, e -> this.selectCategory("clothes")));
    }
}

