/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5532;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ai.selector.NPCInteractSelector;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIWander
extends class_1352 {
    private EntityNPCInterface entity;
    public final NPCInteractSelector selector;
    private double x;
    private double y;
    private double zPosition;
    private EntityNPCInterface nearbyNPC;

    public EntityAIWander(EntityNPCInterface npc) {
        this.entity = npc;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.selector = new NPCInteractSelector(npc);
    }

    public boolean method_6264() {
        if (this.entity.method_6131() >= 100 || !this.entity.method_5942().method_6357() || this.entity.isInteracting() || this.entity.method_5765() || this.entity.ais.movingPause && this.entity.method_59922().method_43048(80) != 0) {
            return false;
        }
        if (this.entity.ais.npcInteracting && this.entity.method_59922().method_43048(this.entity.ais.movingPause ? 6 : 16) == 1) {
            this.nearbyNPC = this.getNearbyNPC();
        }
        if (this.nearbyNPC != null) {
            this.x = class_3532.method_15357((double)this.nearbyNPC.method_23317());
            this.y = class_3532.method_15357((double)this.nearbyNPC.method_23318());
            this.zPosition = class_3532.method_15357((double)this.nearbyNPC.method_23321());
            this.nearbyNPC.addInteract((class_1309)this.entity);
        } else {
            class_243 vec = this.getVec();
            if (vec == null) {
                return false;
            }
            this.x = vec.field_1352;
            this.y = vec.field_1351;
            if (this.entity.ais.movementType == 1) {
                this.y = this.entity.getStartYPos() + (double)this.entity.method_59922().method_43057() * 0.75 * (double)this.entity.ais.walkingRange;
            }
            this.zPosition = vec.field_1350;
        }
        return true;
    }

    public void method_6268() {
        if (this.nearbyNPC != null) {
            this.nearbyNPC.method_5942().method_6340();
        }
    }

    private EntityNPCInterface getNearbyNPC() {
        List list = this.entity.method_37908().method_8333((class_1297)this.entity, this.entity.method_5829().method_1009((double)this.entity.ais.walkingRange, this.entity.ais.walkingRange > 7 ? 7.0 : (double)this.entity.ais.walkingRange, (double)this.entity.ais.walkingRange), (Predicate)((Object)this.selector));
        Iterator ita = list.iterator();
        while (ita.hasNext()) {
            EntityNPCInterface npc = (EntityNPCInterface)((Object)ita.next());
            if (npc.ais.stopAndInteract && !npc.isAttacking() && npc.method_5805() && !this.entity.faction.isAggressiveToNpc(npc)) continue;
            ita.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        return (EntityNPCInterface)((Object)list.get(this.entity.method_59922().method_43048(list.size())));
    }

    private class_243 getVec() {
        if (this.entity.ais.walkingRange > 0) {
            class_2338 start = new class_2338((int)this.entity.getStartXPos(), (int)this.entity.getStartYPos(), (int)this.entity.getStartZPos());
            int distance = (int)Math.sqrt(this.entity.method_24515().method_10262((class_2382)start));
            int range = Math.min(this.entity.ais.walkingRange, CustomNpcs.NpcNavRange);
            if (range - distance < 4) {
                class_243 pos2 = new class_243((this.entity.method_23317() + (double)start.method_10263()) / 2.0, (this.entity.method_23318() + (double)start.method_10264()) / 2.0, (this.entity.method_23321() + (double)start.method_10260()) / 2.0);
                return class_5532.method_31512((class_1314)this.entity, (int)(range / 2), (int)Math.min(range / 2, 7), (class_243)pos2, (double)1.5707963267948966);
            }
            return class_5532.method_31510((class_1314)this.entity, (int)(range / 2), (int)Math.min(range / 2, 7));
        }
        return class_5532.method_31510((class_1314)this.entity, (int)CustomNpcs.NpcNavRange, (int)7);
    }

    public boolean method_6266() {
        if (this.nearbyNPC != null && (!this.selector.apply((Object)this.nearbyNPC) || this.entity.isInRange((class_1297)this.nearbyNPC, this.entity.method_17681()))) {
            return false;
        }
        return !this.entity.method_5942().method_6357() && this.entity.method_5805() && !this.entity.isInteracting();
    }

    public void method_6269() {
        this.entity.method_5942().method_6334(this.entity.method_5942().method_6352(this.x, this.y, this.zPosition, 0), 1.0);
    }

    public void method_6270() {
        if (this.nearbyNPC != null && this.entity.isInRange((class_1297)this.nearbyNPC, 3.5)) {
            Line line;
            EntityNPCInterface talk = this.entity;
            if (this.entity.method_59922().method_43056()) {
                talk = this.nearbyNPC;
            }
            if ((line = talk.advanced.getNPCInteractLine()) == null) {
                line = new Line(".........");
            }
            line.setShowText(false);
            talk.saySurrounding(line);
            this.entity.addInteract((class_1309)this.nearbyNPC);
            this.nearbyNPC.addInteract((class_1309)this.entity);
        }
        this.nearbyNPC = null;
    }
}

