/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.IEntityPersistentData;
import noppes.npcs.mixin.EntityIMixin;
import noppes.npcs.shared.common.util.LRUHashMap;

public class BlockWrapper
implements IBlock {
    private static final Map<String, BlockWrapper> blockCache = new LRUHashMap<String, BlockWrapper>(400);
    protected final IWorld level;
    protected final class_2248 block;
    protected final class_2338 pos;
    protected final BlockPosWrapper bPos;
    protected class_2586 tile;
    protected TileNpcEntity storage;
    private final IData tempdata = new IData(){

        @Override
        public void remove(String key) {
            if (BlockWrapper.this.storage == null) {
                return;
            }
            BlockWrapper.this.storage.tempData.remove(key);
        }

        @Override
        public void put(String key, Object value) {
            if (BlockWrapper.this.storage == null) {
                return;
            }
            BlockWrapper.this.storage.tempData.put(key, value);
        }

        @Override
        public boolean has(String key) {
            if (BlockWrapper.this.storage == null) {
                return false;
            }
            return BlockWrapper.this.storage.tempData.containsKey(key);
        }

        @Override
        public Object get(String key) {
            if (BlockWrapper.this.storage == null) {
                return null;
            }
            return BlockWrapper.this.storage.tempData.get(key);
        }

        @Override
        public void clear() {
            if (BlockWrapper.this.storage == null) {
                return;
            }
            BlockWrapper.this.storage.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return BlockWrapper.this.storage.tempData.keySet().toArray(new String[BlockWrapper.this.storage.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            class_2487 compound = this.getNBT();
            if (compound == null) {
                return;
            }
            if (value instanceof Number) {
                compound.method_10549(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.method_10582(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            class_2487 compound = this.getNBT();
            if (compound == null) {
                return null;
            }
            if (!compound.method_10545(key)) {
                return null;
            }
            class_2520 base = compound.method_10580(key);
            if (base instanceof class_2514) {
                return ((class_2514)base).method_10697();
            }
            return base.method_10714();
        }

        @Override
        public void remove(String key) {
            class_2487 compound = this.getNBT();
            if (compound == null) {
                return;
            }
            compound.method_10551(key);
        }

        @Override
        public boolean has(String key) {
            class_2487 compound = this.getNBT();
            if (compound == null) {
                return false;
            }
            return compound.method_10545(key);
        }

        @Override
        public void clear() {
            if (BlockWrapper.this.tile == null) {
                return;
            }
            ((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().method_10566("CustomNPCsData", (class_2520)new class_2487());
        }

        private class_2487 getNBT() {
            if (BlockWrapper.this.tile == null) {
                return null;
            }
            class_2487 compound = ((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().method_10562("CustomNPCsData");
            if (compound.method_33133() && !((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().method_10545("CustomNPCsData")) {
                ((IEntityPersistentData)BlockWrapper.this.tile).getPersistentData().method_10566("CustomNPCsData", (class_2520)compound);
            }
            return compound;
        }

        @Override
        public String[] getKeys() {
            class_2487 compound = this.getNBT();
            if (compound == null) {
                return new String[0];
            }
            return compound.method_10541().toArray(new String[compound.method_10541().size()]);
        }
    };

    protected BlockWrapper(class_1937 level, class_2248 block, class_2338 pos) {
        this.level = NpcAPI.Instance().getIWorld((class_3218)level);
        this.block = block;
        this.pos = pos;
        this.bPos = new BlockPosWrapper(pos);
        this.setTile(level.method_8321(pos));
    }

    @Override
    public int getX() {
        return this.pos.method_10263();
    }

    @Override
    public int getY() {
        return this.pos.method_10264();
    }

    @Override
    public int getZ() {
        return this.pos.method_10260();
    }

    @Override
    public IPos getPos() {
        return this.bPos;
    }

    @Override
    public Object getProperty(String name) {
        class_2680 state = this.getMCBlockState();
        for (class_2769 p : state.method_28501()) {
            if (!p.method_11899().equalsIgnoreCase(name)) continue;
            return state.method_11654(p);
        }
        throw new CustomNPCsException("Unknown property: " + name, new Object[0]);
    }

    @Override
    public void setProperty(String name, Object val) {
        if (!(val instanceof Comparable)) {
            throw new CustomNPCsException("Not a valid property value: " + String.valueOf(val), new Object[0]);
        }
        class_2680 state = this.getMCBlockState();
        for (class_2769 p : state.method_28501()) {
            if (!p.method_11899().equalsIgnoreCase(name)) continue;
            this.setPropertyValue(state, p, (Comparable)val);
            return;
        }
        throw new CustomNPCsException("Unknown property: " + name, new Object[0]);
    }

    private <T extends Comparable<T>> void setPropertyValue(class_2680 state, class_2769<T> p, Comparable<?> c) {
        this.level.getMCLevel().method_8652(this.pos, (class_2680)state.method_11657(p, (Comparable)p.method_11902().cast(c)), 3);
    }

    @Override
    public String[] getProperties() {
        Collection props = this.getMCBlockState().method_28501();
        ArrayList<String> list = new ArrayList<String>();
        for (class_2769 prop : props) {
            list.add(prop.method_11899());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void remove() {
        this.level.getMCLevel().method_8650(this.pos, false);
    }

    @Override
    public boolean isRemoved() {
        class_2680 state = this.level.getMCLevel().method_8320(this.pos);
        if (state == null) {
            return true;
        }
        return state.method_26204() != this.block;
    }

    @Override
    public boolean isAir() {
        return this.level.getMCLevel().method_8320(this.pos).method_26215();
    }

    @Override
    public BlockWrapper setBlock(String name) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)name));
        if (block == null) {
            return this;
        }
        this.level.getMCLevel().method_8652(this.pos, block.method_9564(), 2);
        return new BlockWrapper((class_1937)this.level.getMCLevel(), block, this.pos);
    }

    @Override
    public BlockWrapper setBlock(IBlock block) {
        this.level.getMCLevel().method_8652(this.pos, block.getMCBlock().method_9564(), 2);
        return new BlockWrapper((class_1937)this.level.getMCLevel(), block.getMCBlock(), this.pos);
    }

    @Override
    public boolean isContainer() {
        if (this.tile == null || !(this.tile instanceof class_1263)) {
            return false;
        }
        return ((class_1263)this.tile).method_5439() > 0;
    }

    @Override
    public IContainer getContainer() {
        if (!this.isContainer()) {
            throw new CustomNPCsException("This block is not a container", new Object[0]);
        }
        return NpcAPI.Instance().getIContainer((class_1263)this.tile);
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public String getName() {
        return class_7923.field_41175.method_10221((Object)this.block).toString();
    }

    @Override
    public String getDisplayName() {
        if (this.tile == null || !(this.tile instanceof class_1275)) {
            return this.getName();
        }
        return ((class_1275)this.tile).method_5476().getString();
    }

    @Override
    public IWorld getWorld() {
        return this.level;
    }

    @Override
    public class_2248 getMCBlock() {
        return this.block;
    }

    @Deprecated
    public static IBlock createNew(class_1937 level, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        String key = state.toString() + pos.toString();
        BlockWrapper b = blockCache.get(key);
        if (b != null) {
            b.setTile(level.method_8321(pos));
            return b;
        }
        b = block instanceof BlockScripted ? new BlockScriptedWrapper(level, block, pos) : (block instanceof BlockScriptedDoor ? new BlockScriptedDoorWrapper(level, block, pos) : new BlockWrapper(level, block, pos));
        blockCache.put(key, b);
        return b;
    }

    public static void clearCache() {
        blockCache.clear();
    }

    @Override
    public boolean hasTileEntity() {
        return this.tile != null;
    }

    protected void setTile(class_2586 tile) {
        this.tile = tile;
        if (tile instanceof TileNpcEntity) {
            this.storage = (TileNpcEntity)tile;
        }
    }

    @Override
    public INbt getBlockEntityNBT() {
        class_2487 compound = this.tile.method_38244((class_7225.class_7874)this.tile.method_10997().method_30349());
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public void setTileEntityNBT(INbt nbt) {
        this.tile.method_58690(nbt.getMCNBT(), (class_7225.class_7874)this.tile.method_10997().method_30349());
        this.tile.method_5431();
        class_2680 state = this.level.getMCLevel().method_8320(this.pos);
        this.level.getMCLevel().method_8413(this.pos, state, state, 3);
    }

    @Override
    public class_2586 getMCTileEntity() {
        return this.tile;
    }

    @Override
    public class_2680 getMCBlockState() {
        return this.level.getMCLevel().method_8320(this.pos);
    }

    @Override
    public void blockEvent(int type, int data) {
        this.level.getMCLevel().method_8427(this.pos, this.getMCBlock(), type, data);
    }

    @Override
    public void interact(int side) {
        FakePlayer player = EntityNPCInterface.GenericPlayer;
        class_3218 w = this.level.getMCLevel();
        ((EntityIMixin)player).setLevel((class_1937)w);
        player.method_5814((double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260());
        this.getMCBlockState().method_55781((class_1937)w, (class_1657)EntityNPCInterface.CommandPlayer, new class_3965(class_243.field_1353, class_2350.method_10143((int)side), this.pos, true));
    }
}

