/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;

public class ContainerWrapper
implements IContainer {
    private class_1263 inventory;
    private class_1703 container;

    public ContainerWrapper(class_1263 inventory) {
        this.inventory = inventory;
    }

    public ContainerWrapper(class_1703 container) {
        this.container = container;
    }

    @Override
    public int getSize() {
        if (this.inventory != null) {
            return this.inventory.method_5439();
        }
        return this.container.field_7761.size();
    }

    @Override
    public IItemStack getSlot(int slot) {
        if (slot < 0 || slot >= this.getSize()) {
            throw new CustomNPCsException("Slot is out of range " + slot, new Object[0]);
        }
        if (this.inventory != null) {
            return NpcAPI.Instance().getIItemStack(this.inventory.method_5438(slot));
        }
        return NpcAPI.Instance().getIItemStack(this.container.method_7611(slot).method_7677());
    }

    @Override
    public void setSlot(int slot, IItemStack item) {
        class_1799 itemstack;
        if (slot < 0 || slot >= this.getSize()) {
            throw new CustomNPCsException("Slot is out of range " + slot, new Object[0]);
        }
        class_1799 class_17992 = itemstack = item == null ? class_1799.field_8037 : item.getMCItemStack();
        if (this.inventory != null) {
            this.inventory.method_5447(slot, itemstack);
        } else {
            this.container.method_7619(slot, this.container.method_37421(), itemstack);
            this.container.method_7623();
        }
    }

    @Override
    public int count(IItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        int count = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            IItemStack toCompare = this.getSlot(i);
            if (!NoppesUtilPlayer.compareItems(item.getMCItemStack(), toCompare.getMCItemStack(), ignoreDamage, ignoreNBT)) continue;
            count += toCompare.getStackSize();
        }
        return count;
    }

    @Override
    public class_1263 getMCInventory() {
        return this.inventory;
    }

    @Override
    public class_1703 getMCContainer() {
        return this.container;
    }

    @Override
    public IItemStack[] getItems() {
        IItemStack[] items = new IItemStack[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            items[i] = this.getSlot(i);
        }
        return items;
    }
}

