/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IRayTrace;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.RayTraceWrapper;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.data.IEntityPersistentData;
import noppes.npcs.mixin.EntityIMixin;

public class EntityWrapper<T extends class_1297>
implements IEntity {
    protected T entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private IWorld levelWrapper;
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            EntityWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return EntityWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            EntityWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return EntityWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return EntityWrapper.this.tempData.keySet().toArray(new String[EntityWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            class_2487 compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.method_10549(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.method_10582(key, (String)value);
            }
            this.saveStoredCompound(compound);
        }

        @Override
        public Object get(String key) {
            class_2487 compound = this.getStoredCompound();
            if (!compound.method_10545(key)) {
                return null;
            }
            class_2520 base = compound.method_10580(key);
            if (base instanceof class_2514) {
                return ((class_2514)base).method_10697();
            }
            return base.method_10714();
        }

        @Override
        public void remove(String key) {
            class_2487 compound = this.getStoredCompound();
            compound.method_10551(key);
            this.saveStoredCompound(compound);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().method_10545(key);
        }

        @Override
        public void clear() {
            ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().method_10551("CNPCStoredData");
        }

        private class_2487 getStoredCompound() {
            class_2487 compound = ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().method_10562("CNPCStoredData");
            if (compound == null) {
                compound = new class_2487();
                ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().method_10566("CNPCStoredData", (class_2520)compound);
            }
            return compound;
        }

        private void saveStoredCompound(class_2487 compound) {
            ((IEntityPersistentData)EntityWrapper.this.entity).getPersistentData().method_10566("CNPCStoredData", (class_2520)compound);
        }

        @Override
        public String[] getKeys() {
            class_2487 compound = this.getStoredCompound();
            return compound.method_10541().toArray(new String[compound.method_10541().size()]);
        }
    };

    public EntityWrapper(T entity) {
        this.entity = entity;
        this.levelWrapper = NpcAPI.Instance().getIWorld((class_3218)entity.method_37908());
    }

    @Override
    public double getX() {
        return this.entity.method_23317();
    }

    @Override
    public void setX(double x) {
        this.entity.method_5814(x, this.entity.method_23318(), this.entity.method_23321());
    }

    @Override
    public double getY() {
        return this.entity.method_23318();
    }

    @Override
    public void setY(double y) {
        this.entity.method_5814(this.entity.method_23317(), y, this.entity.method_23321());
    }

    @Override
    public double getZ() {
        return this.entity.method_23321();
    }

    @Override
    public void setZ(double z) {
        this.entity.method_5814(this.entity.method_23317(), this.entity.method_23318(), z);
    }

    @Override
    public int getBlockX() {
        return class_3532.method_15357((double)this.entity.method_23317());
    }

    @Override
    public int getBlockY() {
        return class_3532.method_15357((double)this.entity.method_23318());
    }

    @Override
    public int getBlockZ() {
        return class_3532.method_15357((double)this.entity.method_23321());
    }

    @Override
    public String getEntityName() {
        String s = this.entity.method_5864().method_5882();
        return class_2477.method_10517().method_48307(s);
    }

    @Override
    public String getName() {
        return this.entity.method_5477().getString();
    }

    @Override
    public void setName(String name) {
        this.entity.method_5665((class_2561)class_2561.method_43470((String)name));
    }

    @Override
    public boolean hasCustomName() {
        return this.entity.method_16914();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.method_5814(x, y, z);
    }

    @Override
    public IWorld getWorld() {
        if (this.entity.method_37908() != this.levelWrapper.getMCLevel()) {
            this.levelWrapper = NpcAPI.Instance().getIWorld((class_3218)this.entity.method_37908());
        }
        return this.levelWrapper;
    }

    @Override
    public boolean isAlive() {
        return this.entity.method_5805();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public long getAge() {
        return ((class_1297)this.entity).field_6012;
    }

    @Override
    public void damage(float amount) {
        if (this.getType() == 1 && (((IPlayer)((Object)this)).getGamemode() == 1 || ((IPlayer)((Object)this)).getGamemode() == 3)) {
            return;
        }
        this.entity.method_5643(this.entity.method_48923().method_51847(), amount);
    }

    @Override
    public void damage(float damage, IEntity source) {
        if (source.getMCEntity() instanceof class_1657) {
            this.entity.method_5643(this.entity.method_48923().method_48802((class_1657)source.getMCEntity()), damage);
        } else {
            class_6880.class_6883 damageTypeHolder = this.entity.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(NpcDamageSource.NPC);
            this.entity.method_5643(new class_1282((class_6880)damageTypeHolder, source.getMCEntity()), damage);
        }
    }

    @Override
    public void despawn() {
        this.entity.method_31472();
    }

    @Override
    public void spawn() {
        if (this.levelWrapper.getMCLevel().method_14190(this.entity.method_5667()) != null) {
            throw new CustomNPCsException("Entity is already spawned", new Object[0]);
        }
        ((EntityIMixin)this.entity).removal(null);
        this.levelWrapper.getMCLevel().method_8649(this.entity);
    }

    @Override
    public void kill() {
        this.entity.method_5768();
    }

    @Override
    public boolean inWater() {
        return this.entity.method_5799();
    }

    @Override
    public boolean inLava() {
        return this.entity.method_5771();
    }

    @Override
    public boolean inFire() {
        return this.entity.method_37908().method_29546(this.entity.method_5829()).anyMatch(state -> state.method_26164(class_3481.field_21952));
    }

    @Override
    public boolean isBurning() {
        return this.entity.method_5809();
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.method_20803(ticks);
    }

    @Override
    public void extinguish() {
        this.entity.method_5646();
    }

    @Override
    public String getTypeName() {
        return this.entity.method_5653();
    }

    @Override
    public IEntityItem dropItem(IItemStack item) {
        return (IEntityItem)NpcAPI.Instance().getIEntity((class_1297)this.entity.method_5699(item.getMCItemStack(), 0.0f));
    }

    @Override
    public IEntity[] getRiders() {
        List list = this.entity.method_5685();
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((class_1297)list.get(i));
        }
        return riders;
    }

    @Override
    public IRayTrace rayTraceBlock(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        class_243 vec3d = this.entity.method_5836(1.0f);
        class_243 vec3d1 = this.entity.method_5828(1.0f);
        class_243 vec3d2 = vec3d.method_1031(vec3d1.field_1352 * distance, vec3d1.field_1351 * distance, vec3d1.field_1350 * distance);
        class_3965 result = this.entity.method_37908().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17559, stopOnLiquid ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, this.entity));
        if (result.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        class_3965 br = result;
        return new RayTraceWrapper(NpcAPI.Instance().getIBlock(this.entity.method_37908(), br.method_17777()), br.method_17780().method_10146());
    }

    @Override
    public IEntity[] rayTraceEntities(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        class_243 vec3d = this.entity.method_5836(1.0f);
        class_243 vec3d1 = this.entity.method_5828(1.0f);
        class_243 vec3d2 = vec3d.method_1031(vec3d1.field_1352 * distance, vec3d1.field_1351 * distance, vec3d1.field_1350 * distance);
        class_3965 result = this.entity.method_37908().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, stopOnLiquid ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, this.entity));
        if (result.method_17783() != class_239.class_240.field_1333) {
            vec3d2 = result.method_17784();
        }
        return this.findEntityOnPath(distance, vec3d, vec3d2);
    }

    private IEntity[] findEntityOnPath(double distance, class_243 vec3d, class_243 vec3d1) {
        List list = this.entity.method_37908().method_8335(this.entity, this.entity.method_5829().method_1014(distance));
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        for (class_1297 entity1 : list) {
            class_238 axisalignedbb;
            Optional optional;
            if (entity1 == this.entity || !(optional = (axisalignedbb = entity1.method_5829().method_1014((double)entity1.method_5871())).method_992(vec3d, vec3d1)).isPresent()) continue;
            result.add(NpcAPI.Instance().getIEntity(entity1));
        }
        result.sort((o1, o2) -> {
            double d2;
            double d1 = this.entity.method_5858(o1.getMCEntity());
            if (d1 == (d2 = this.entity.method_5858(o2.getMCEntity()))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        });
        return result.toArray(new IEntity[result.size()]);
    }

    @Override
    public IEntity[] getAllRiders() {
        ImmutableList list = ImmutableList.copyOf((Iterable)this.entity.method_5736());
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((class_1297)list.get(i));
        }
        return riders;
    }

    @Override
    public void addRider(IEntity entity) {
        if (entity != null) {
            entity.getMCEntity().method_5873(this.entity, true);
        }
    }

    @Override
    public void clearRiders() {
        this.entity.method_5772();
    }

    @Override
    public IEntity getMount() {
        return NpcAPI.Instance().getIEntity(this.entity.method_5854());
    }

    @Override
    public void setMount(IEntity entity) {
        if (entity == null) {
            this.entity.method_5848();
        } else {
            this.entity.method_5873(entity.getMCEntity(), true);
        }
    }

    @Override
    public void setRotation(float rotation) {
        this.entity.method_36456(rotation);
    }

    @Override
    public float getRotation() {
        return this.entity.method_36454();
    }

    @Override
    public void setPitch(float rotation) {
        this.entity.method_36457(rotation);
    }

    @Override
    public float getPitch() {
        return this.entity.method_36455();
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.method_5762((double)(-class_3532.method_15374((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(class_3532.method_15362((float)v) * (float)power));
        this.entity.method_18799(this.entity.method_18798().method_18805(0.6, 1.0, 0.6));
        ((class_1297)this.entity).field_6037 = true;
    }

    @Override
    public boolean isSneaking() {
        return this.entity.method_18276();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.method_5624();
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean typeOf(int type) {
        return type == this.getType();
    }

    @Override
    public String getUUID() {
        return this.entity.method_5667().toString();
    }

    @Override
    public String generateNewUUID() {
        UUID id = UUID.randomUUID();
        this.entity.method_5826(id);
        return id.toString();
    }

    @Override
    public INbt getNbt() {
        return NpcAPI.Instance().getINbt(((IEntityPersistentData)this.entity).getPersistentData());
    }

    @Override
    public void storeAsClone(int tab, String name) {
        class_2487 compound = new class_2487();
        if (!this.entity.method_5786(compound)) {
            throw new CustomNPCsException("Cannot store dead entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }

    @Override
    public INbt getEntityNbt() {
        class_2487 compound = new class_2487();
        this.entity.method_5647(compound);
        class_2960 resourcelocation = class_1299.method_5890((class_1299)this.entity.method_5864());
        if (this.getType() == 1) {
            resourcelocation = class_2960.method_12829((String)"player");
        }
        if (resourcelocation != null) {
            compound.method_10582("id", resourcelocation.toString());
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public void setEntityNbt(INbt nbt) {
        this.entity.method_5651(nbt.getMCNBT());
    }

    @Override
    public void playAnimation(int type) {
        this.levelWrapper.getMCLevel().method_14178().method_18751(this.entity, (class_2596)new class_2616(this.entity, type));
    }

    @Override
    public float getHeight() {
        return this.entity.method_17682();
    }

    @Override
    public float getEyeHeight() {
        return this.entity.method_5751();
    }

    @Override
    public float getWidth() {
        return this.entity.method_17681();
    }

    @Override
    public IPos getPos() {
        return new BlockPosWrapper(this.entity.method_24515());
    }

    @Override
    public void setPos(IPos pos) {
        this.entity.method_5814((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
    }

    @Override
    public String[] getTags() {
        return this.entity.method_5752().toArray(new String[this.entity.method_5752().size()]);
    }

    @Override
    public void addTag(String tag) {
        this.entity.method_5780(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.entity.method_5752().contains(tag);
    }

    @Override
    public void removeTag(String tag) {
        this.entity.method_5738(tag);
    }

    @Override
    public double getMotionX() {
        return this.entity.method_18798().field_1352;
    }

    @Override
    public double getMotionY() {
        return this.entity.method_18798().field_1351;
    }

    @Override
    public double getMotionZ() {
        return this.entity.method_18798().field_1350;
    }

    @Override
    public void setMotionX(double motion) {
        class_243 mo = this.entity.method_18798();
        if (mo.field_1352 == motion) {
            return;
        }
        this.entity.method_18800(motion, mo.field_1351, mo.field_1350);
        ((class_1297)this.entity).field_6037 = true;
    }

    @Override
    public void setMotionY(double motion) {
        class_243 mo = this.entity.method_18798();
        if (mo.field_1351 == motion) {
            return;
        }
        this.entity.method_18800(mo.field_1352, motion, mo.field_1350);
        ((class_1297)this.entity).field_6037 = true;
    }

    @Override
    public void setMotionZ(double motion) {
        class_243 mo = this.entity.method_18798();
        if (mo.field_1350 == motion) {
            return;
        }
        this.entity.method_18800(mo.field_1352, mo.field_1351, motion);
        ((class_1297)this.entity).field_6037 = true;
    }
}

