/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_269;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IScoreboardTeam;

public class ScoreboardTeamWrapper
implements IScoreboardTeam {
    private class_268 team;
    private class_269 board;

    protected ScoreboardTeamWrapper(class_268 team, class_269 board) {
        this.team = team;
        this.board = board;
    }

    @Override
    public String getName() {
        return this.team.method_1197();
    }

    @Override
    public String getDisplayName() {
        return this.team.method_1140().getString();
    }

    @Override
    public void setDisplayName(String name) {
        if (name.length() <= 0 || name.length() > 32) {
            throw new CustomNPCsException("Score team display name must be between 1-32 characters: %s", name);
        }
        this.team.method_1137((class_2561)class_2561.method_43471((String)name));
    }

    @Override
    public void addPlayer(String player) {
        this.board.method_1172(player, this.team);
    }

    @Override
    public void removePlayer(String player) {
        this.board.method_1157(player, this.team);
    }

    @Override
    public String[] getPlayers() {
        ArrayList list = new ArrayList(this.team.method_1204());
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void clearPlayers() {
        ArrayList list = new ArrayList(this.team.method_1204());
        for (String player : list) {
            this.board.method_1157(player, this.team);
        }
    }

    @Override
    public boolean getFriendlyFire() {
        return this.team.method_1205();
    }

    @Override
    public void setFriendlyFire(boolean bo) {
        this.team.method_1135(bo);
    }

    @Override
    public void setColor(String color) {
        class_124 enumchatformatting = class_124.method_533((String)color);
        if (enumchatformatting == null || enumchatformatting.method_542()) {
            throw new CustomNPCsException("Not a proper color name: %s", color);
        }
        this.team.method_1138((class_2561)class_2561.method_43470((String)enumchatformatting.toString()));
        this.team.method_1139((class_2561)class_2561.method_43470((String)class_124.field_1070.toString()));
    }

    @Override
    public String getColor() {
        class_2561 prefix = this.team.method_1144();
        if (prefix == null || prefix.getString().isEmpty()) {
            return null;
        }
        for (class_124 format : class_124.values()) {
            if (!prefix.getString().equals(format.toString()) || format == class_124.field_1070) continue;
            return format.method_537();
        }
        return null;
    }

    @Override
    public void setSeeInvisibleTeamPlayers(boolean bo) {
        this.team.method_1143(bo);
    }

    @Override
    public boolean getSeeInvisibleTeamPlayers() {
        return this.team.method_1199();
    }

    @Override
    public boolean hasPlayer(String player) {
        return this.board.method_1164(player) != null;
    }
}

