/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1682;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import noppes.npcs.EventHooks;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IDimension;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IScoreboard;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.DimensionWrapper;
import noppes.npcs.api.wrapper.ScoreboardWrapper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketPlaySound;

public class WorldWrapper
implements IWorld {
    public static Map<String, Object> tempData = new HashMap<String, Object>();
    public class_3218 level;
    public IDimension dimension;
    private IData tempdata = new IData(this){

        @Override
        public void put(String key, Object value) {
            tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return tempData.get(key);
        }

        @Override
        public void remove(String key) {
            tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return tempData.containsKey(key);
        }

        @Override
        public void clear() {
            tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return tempData.keySet().toArray(new String[tempData.size()]);
        }
    };
    private IData storeddata = new IData(this){

        @Override
        public void put(String key, Object value) {
            class_2487 compound = ScriptController.Instance.compound;
            if (value instanceof Number) {
                compound.method_10549(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.method_10582(key, (String)value);
            }
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public Object get(String key) {
            class_2487 compound = ScriptController.Instance.compound;
            if (!compound.method_10545(key)) {
                return null;
            }
            class_2520 base = compound.method_10580(key);
            if (base instanceof class_2514) {
                return ((class_2514)base).method_10697();
            }
            return base.method_10714();
        }

        @Override
        public void remove(String key) {
            ScriptController.Instance.compound.method_10551(key);
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public boolean has(String key) {
            return ScriptController.Instance.compound.method_10545(key);
        }

        @Override
        public void clear() {
            ScriptController.Instance.compound = new class_2487();
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public String[] getKeys() {
            return ScriptController.Instance.compound.method_10541().toArray(new String[ScriptController.Instance.compound.method_10541().size()]);
        }
    };

    private WorldWrapper(class_1937 level) {
        this.level = (class_3218)level;
        this.dimension = new DimensionWrapper(level.method_27983().method_29177(), level.method_8597());
    }

    @Override
    public class_3218 getMCLevel() {
        return this.level;
    }

    @Override
    public IEntity[] getNearbyEntities(int x, int y, int z, int range, int type) {
        return this.getNearbyEntities(new BlockPosWrapper(new class_2338(x, y, z)), range, type);
    }

    @Override
    public IEntity[] getNearbyEntities(IPos pos, int range, int type) {
        class_238 bb = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).method_996(pos.getMCBlockPos()).method_1009((double)range, (double)range, (double)range);
        List entities = this.level.method_18467(this.getClassForType(type), bb);
        ArrayList<IEntity> list = new ArrayList<IEntity>();
        for (class_1297 living : entities) {
            list.add(NpcAPI.Instance().getIEntity(living));
        }
        return list.toArray(new IEntity[list.size()]);
    }

    @Override
    public IEntity[] getAllEntities(int type) {
        List<class_1297> entities = this.getEntities(this.getClassForType(type), class_1301.field_6156);
        ArrayList<IEntity> list = new ArrayList<IEntity>();
        for (class_1297 living : entities) {
            list.add(NpcAPI.Instance().getIEntity(living));
        }
        return list.toArray(new IEntity[list.size()]);
    }

    public List<class_1297> getEntities(Class<?> entityTypeIn, Predicate<? super class_1297> predicateIn) {
        ArrayList list = Lists.newArrayList();
        class_3215 serverchunkprovider = this.level.method_14178();
        for (class_1297 entity : this.level.method_31592().method_31803()) {
            if (!entityTypeIn.isAssignableFrom(entity.getClass()) || !serverchunkprovider.method_12123(class_3532.method_15357((double)entity.method_23317()) >> 4, class_3532.method_15357((double)entity.method_23321()) >> 4) || !predicateIn.test((class_1297)entity)) continue;
            list.add(entity);
        }
        return list;
    }

    @Override
    public IEntity getClosestEntity(int x, int y, int z, int range, int type) {
        return this.getClosestEntity(new BlockPosWrapper(new class_2338(x, y, z)), range, type);
    }

    @Override
    public IEntity getClosestEntity(IPos pos, int range, int type) {
        class_238 bb = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).method_996(pos.getMCBlockPos()).method_1009((double)range, (double)range, (double)range);
        List entities = this.level.method_18467(this.getClassForType(type), bb);
        double distance = range * range * range;
        class_1297 entity = null;
        for (class_1297 e : entities) {
            double r = pos.getMCBlockPos().method_10262((class_2382)e.method_24515());
            if (entity == null) {
                distance = r;
                entity = e;
                continue;
            }
            if (!(r < distance)) continue;
            distance = r;
            entity = e;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IEntity getEntity(String uuid) {
        try {
            UUID id = UUID.fromString(uuid);
            class_1297 e = this.level.method_14190(id);
            if (e == null) {
                e = this.level.method_18470(id);
            }
            if (e == null) {
                return null;
            }
            return NpcAPI.Instance().getIEntity(e);
        }
        catch (Exception e) {
            throw new CustomNPCsException("Given uuid was invalid " + uuid, new Object[0]);
        }
    }

    @Override
    public IEntity createEntityFromNBT(INbt nbt) {
        class_1297 entity = class_1299.method_5892((class_2487)nbt.getMCNBT(), (class_1937)this.level).orElse(null);
        if (entity == null) {
            throw new CustomNPCsException("Failed to create an entity from given NBT", new Object[0]);
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IEntity createEntity(String id) {
        class_2960 resource = class_2960.method_12829((String)id);
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(resource);
        class_1297 entity = type.method_5883((class_1937)this.level);
        if (entity == null) {
            throw new CustomNPCsException("Failed to create an entity from given id: " + id, new Object[0]);
        }
        entity.method_5814(0.0, 1.0, 0.0);
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IPlayer getPlayer(String name) {
        for (class_1657 entityplayer : this.level.method_18456()) {
            if (!name.equals(entityplayer.method_5477().getString())) continue;
            return (IPlayer)NpcAPI.Instance().getIEntity((class_1297)entityplayer);
        }
        return null;
    }

    private Class getClassForType(int type) {
        if (type == -1) {
            return class_1297.class;
        }
        if (type == 5) {
            return class_1309.class;
        }
        if (type == 1) {
            return class_1657.class;
        }
        if (type == 4) {
            return class_1429.class;
        }
        if (type == 3) {
            return class_1588.class;
        }
        if (type == 2) {
            return EntityNPCInterface.class;
        }
        if (type == 6) {
            return class_1542.class;
        }
        if (type == 7) {
            return EntityProjectile.class;
        }
        if (type == 11) {
            return class_1682.class;
        }
        if (type == 10) {
            return class_1665.class;
        }
        if (type == 8) {
            return PixelmonHelper.getPixelmonClass();
        }
        if (type == 9) {
            return class_1646.class;
        }
        return class_1297.class;
    }

    @Override
    public long getTime() {
        return this.level.method_8532();
    }

    @Override
    public void setTime(long time) {
        this.level.method_29199(time);
    }

    @Override
    public long getTotalTime() {
        return this.level.method_8510();
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        return NpcAPI.Instance().getIBlock((class_1937)this.level, new class_2338(x, y, z));
    }

    @Override
    public IBlock getBlock(IPos pos) {
        return NpcAPI.Instance().getIBlock((class_1937)this.level, pos.getMCBlockPos());
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.level.method_14178().method_12123(x >> 4, z >> 4);
    }

    @Override
    public void setBlock(int x, int y, int z, String name, int meta) {
        this.setBlock(NpcAPI.Instance().getIPos(x, y, z), name);
    }

    @Override
    public IBlock setBlock(IPos pos, String name) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)name));
        if (block == null) {
            throw new CustomNPCsException("There is no such block: %s", name);
        }
        this.level.method_8652(pos.getMCBlockPos(), block.method_9564(), 2);
        return NpcAPI.Instance().getIBlock((class_1937)this.level, pos.getMCBlockPos());
    }

    @Override
    public void removeBlock(int x, int y, int z) {
        this.level.method_8650(new class_2338(x, y, z), false);
    }

    @Override
    public void removeBlock(IPos pos) {
        this.level.method_8650(pos.getMCBlockPos(), false);
    }

    @Override
    public float getLightValue(int x, int y, int z) {
        return (float)this.level.method_8317(new class_2338(x, y, z)) / 16.0f;
    }

    @Override
    public IBlock getSpawnPoint() {
        class_2338 pos = this.level.method_43126();
        if (pos == null) {
            pos = this.level.method_43126();
        }
        return NpcAPI.Instance().getIBlock((class_1937)this.level, pos);
    }

    @Override
    public void setSpawnPoint(IBlock block) {
        class_5268 info = (class_5268)this.level.method_8401();
        info.method_187(new class_2338(block.getX(), block.getY(), block.getZ()), 0.0f);
    }

    @Override
    public boolean isDay() {
        return this.level.method_8532() % 24000L < 12000L;
    }

    @Override
    public boolean isRaining() {
        return this.level.method_8401().method_156();
    }

    @Override
    public void setRaining(boolean bo) {
        class_5268 data = (class_5268)this.level.method_8401();
        if (bo) {
            data.method_157(true);
            data.method_164(120000000);
        } else {
            data.method_157(false);
            data.method_164(0);
        }
    }

    @Override
    public void thunderStrike(double x, double y, double z) {
        class_1538 bolt = (class_1538)class_1299.field_6112.method_5883((class_1937)this.level);
        bolt.method_24203(x, y, z);
        bolt.method_29498(false);
        this.level.method_8649((class_1297)bolt);
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        class_2396 type = (class_2396)class_7923.field_41180.method_10223(class_2960.method_12829((String)particle));
        if (type == null) {
            throw new CustomNPCsException("Unknown particle type: " + particle, new Object[0]);
        }
        this.level.method_14199((class_2394)type, x, y, z, count, dx, dy, dz, speed);
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public IItemStack createItem(String name, int size) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)name));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + name, new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(new class_1799((class_1935)item, size));
    }

    @Override
    public IItemStack createItemFromNbt(INbt nbt) {
        class_1799 item = class_1799.method_57359((class_7225.class_7874)this.level.method_30349(), (class_2487)nbt.getMCNBT());
        if (item.method_7960()) {
            throw new CustomNPCsException("Failed to create an item from given NBT", new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(item);
    }

    @Override
    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.level.method_8537(null, x, y, z, range, fire, grief ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40888);
    }

    @Override
    public IPlayer[] getAllPlayers() {
        List list = this.level.method_8503().method_3760().method_14571();
        IPlayer[] arr = new IPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (IPlayer)NpcAPI.Instance().getIEntity((class_1297)list.get(i));
        }
        return arr;
    }

    @Override
    public String getBiomeName(int x, int z) {
        try {
            return ((class_5321)this.level.method_23753(new class_2338(x, 0, z)).method_40230().get()).method_29177().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public IEntity spawnClone(double x, double y, double z, int tab, String name) {
        return NpcAPI.Instance().getClones().spawn(x, y, z, tab, name, this);
    }

    @Override
    public void spawnEntity(IEntity entity) {
        if (entity == null) {
            throw new CustomNPCsException("Entity given was null", new Object[0]);
        }
        Object e = entity.getMCEntity();
        if (this.level.method_14190(e.method_5667()) != null) {
            throw new CustomNPCsException("Entity with this UUID already exists", new Object[0]);
        }
        e.method_5814(e.method_23317(), e.method_23318(), e.method_23321());
        this.level.method_8649(e);
    }

    @Override
    public IEntity getClone(int tab, String name) {
        return NpcAPI.Instance().getClones().get(tab, name, this);
    }

    @Override
    public IScoreboard getScoreboard() {
        return new ScoreboardWrapper(this.level.method_8503());
    }

    @Override
    public void broadcast(String message) {
        class_5250 text = class_2561.method_43470((String)message);
        for (class_1657 p : this.level.method_18766(e -> true)) {
            p.method_43496((class_2561)text);
        }
    }

    @Override
    public int getRedstonePower(int x, int y, int z) {
        return this.level.method_49809(new class_2338(x, y, z));
    }

    @Deprecated
    public static WorldWrapper createNew(class_3218 level) {
        return new WorldWrapper((class_1937)level);
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public String getName() {
        return ((class_5268)this.level.method_8401()).method_150();
    }

    @Override
    public class_2338 getMCBlockPos(int x, int y, int z) {
        return new class_2338(x, y, z);
    }

    @Override
    public void playSoundAt(IPos pos, String sound, float volume, float pitch) {
        class_2338 bp = pos.getMCBlockPos();
        Packets.sendNearby((class_1937)this.level, bp, 16, new PacketPlaySound(sound, bp, volume, pitch));
    }

    @Override
    public void trigger(int id, Object ... arguments) {
        EventHooks.onScriptTriggerEvent(ScriptController.Instance.forgeScripts, id, this, BlockPosWrapper.ZERO, null, arguments);
    }
}

