/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.GuiComponentsScrollableWrapper;
import noppes.npcs.api.wrapper.gui.GuiComponentsWrapper;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiComponentUpdate;
import noppes.npcs.packets.client.PacketGuiData;

public class CustomGuiWrapper
extends GuiComponentsWrapper
implements ICustomGui {
    private int id;
    private int width;
    private int height;
    private boolean pauseGame;
    private final CustomGuiTexturedRectWrapper background = new CustomGuiTexturedRectWrapper();
    private final GuiComponentsScrollableWrapper scrollingPanel;
    private ScriptContainer scriptHandler;
    private CustomGuiWrapper parent;
    private CustomGuiWrapper subgui;
    public EntityCustomNpc npc;

    public CustomGuiWrapper(IPlayer player) {
        super(player);
        this.scrollingPanel = new GuiComponentsScrollableWrapper(this, player);
    }

    public CustomGuiWrapper(IPlayer player, int id, int width, int height, boolean pauseGame) {
        this(player);
        this.id = id;
        this.setSize(width, height);
        this.pauseGame = pauseGame;
        this.scriptHandler = ScriptContainer.Current;
        this.background.setID(-1);
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public ScriptContainer getScriptHandler() {
        return this.scriptHandler;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.background.getWidth() <= 0 || this.background.getHeight() <= 0) {
            this.background.setSize(width, height);
        }
    }

    @Override
    public void setDoesPauseGame(boolean pauseGame) {
        this.pauseGame = pauseGame;
    }

    public boolean getDoesPauseGame() {
        return this.pauseGame;
    }

    @Override
    public void setBackgroundTexture(String resourceLocation) {
        this.background.texture = resourceLocation;
    }

    public String getBackgroundTexture() {
        return this.background.texture;
    }

    public ITexturedRect getBackgroundRect() {
        return this.background;
    }

    @Override
    public GuiComponentsScrollableWrapper getScrollingPanel() {
        return this.scrollingPanel;
    }

    @Override
    public void openSubGui(ICustomGui gui) {
        this.subgui = (CustomGuiWrapper)gui;
        this.subgui.parent = this;
        this.subgui.npc = this.npc;
        this.getRootGui().update();
    }

    @Override
    public CustomGuiWrapper getSubGui() {
        return this.subgui;
    }

    @Override
    public boolean hasSubGui() {
        return this.subgui != null;
    }

    @Override
    public CustomGuiWrapper closeSubGui() {
        if (this.subgui == null) {
            throw new CustomNPCsException("Current gui has no subgui", new Object[0]);
        }
        CustomGuiWrapper gui = this.subgui;
        this.subgui = null;
        this.player.showCustomGui(this.getRootGui());
        return gui;
    }

    @Override
    public void close() {
        if (this.parent == null) {
            this.player.closeGui();
        } else {
            this.parent.subgui = null;
            this.getRootGui().update();
        }
    }

    @Override
    public CustomGuiWrapper getParentGui() {
        return this.parent;
    }

    @Override
    public CustomGuiWrapper getRootGui() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootGui();
    }

    @Override
    public CustomGuiWrapper getActiveGui() {
        if (this.subgui == null) {
            return this;
        }
        return this.subgui.getActiveGui();
    }

    @Override
    public IPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void update() {
        if (((class_3222)this.player.getMCEntity()).field_7512 instanceof ContainerCustomGui) {
            Packets.send(this.player.getMCEntity(), new PacketGuiData(this.getRootGui().toNBT()));
        }
        ((ContainerCustomGui)((class_3222)this.player.getMCEntity()).field_7512).setGui(this.getActiveGui(), (class_1657)this.player.getMCEntity());
    }

    @Override
    public void update(ICustomGuiComponent component) {
        if (((class_3222)this.player.getMCEntity()).field_7512 instanceof ContainerCustomGui) {
            Packets.send(this.player.getMCEntity(), new PacketGuiComponentUpdate(component.getUniqueID(), ((CustomGuiComponentWrapper)component).toNBT(new class_2487())));
        }
    }

    public ICustomGui fromNBT(class_2487 tag) {
        this.id = tag.method_10550("id");
        this.width = tag.method_10561("size")[0];
        this.height = tag.method_10561("size")[1];
        this.pauseGame = tag.method_10577("pause");
        this.background.fromNBT(tag.method_10562("backgroundRect"));
        this.setComponentNbt(tag.method_10562("components"));
        this.scrollingPanel.setComponentNbt(tag.method_10562("scrolling_components"));
        if (tag.method_10545("subgui")) {
            if (this.subgui == null) {
                this.subgui = new CustomGuiWrapper(this.player);
                this.subgui.fromNBT(tag.method_10562("subgui"));
            }
        } else {
            this.subgui = null;
        }
        return this;
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        tag.method_10569("id", this.id);
        tag.method_10539("size", new int[]{this.width, this.height});
        tag.method_10556("pause", this.pauseGame);
        tag.method_10566("backgroundRect", (class_2520)this.background.toNBT(new class_2487()));
        tag.method_10566("components", (class_2520)this.getComponentNbt());
        tag.method_10566("scrolling_components", (class_2520)this.scrollingPanel.getComponentNbt());
        if (this.parent == null) {
            tag.method_10569("slotSize", this.getActiveGui().getSlots().size());
        }
        if (this.subgui != null) {
            tag.method_10566("subgui", (class_2520)this.subgui.toNBT());
        }
        return tag;
    }

    @Override
    public ICustomGuiComponent getComponentUuid(UUID id) {
        ICustomGuiComponent comp;
        if (this.subgui != null && (comp = this.subgui.getComponentUuid(id)) != null) {
            return comp;
        }
        comp = super.getComponentUuid(id);
        if (comp != null) {
            return comp;
        }
        return this.scrollingPanel.getComponentUuid(id);
    }
}

