/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_7225;
import noppes.npcs.CustomBlocks;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.BlockData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobBuilder;
import noppes.npcs.schematics.SchematicWrapper;

public class TileBuilder
extends class_2586 {
    private SchematicWrapper schematic = null;
    public int rotation = 0;
    public int yOffest = 0;
    public boolean enabled = false;
    public boolean started = false;
    public boolean finished = false;
    public Availability availability = new Availability();
    private Stack<Integer> positions = new Stack();
    private Stack<Integer> positionsSecond = new Stack();
    public static class_2338 DrawPos = null;
    public static boolean Compiled = false;
    private int ticks = 20;

    public TileBuilder(class_2338 pos, class_2680 state) {
        super(CustomBlocks.tile_builder, pos, state);
    }

    protected void method_11014(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11014(compound, registries);
        if (compound.method_10545("SchematicName")) {
            this.schematic = SchematicController.Instance.load(compound.method_10558("SchematicName"));
        }
        Stack<Integer> positions = new Stack<Integer>();
        positions.addAll(NBTTags.getIntegerList(compound.method_10554("Positions", 10)));
        this.positions = positions;
        positions = new Stack();
        positions.addAll(NBTTags.getIntegerList(compound.method_10554("PositionsSecond", 10)));
        this.positionsSecond = positions;
        this.readPartNBT(compound);
    }

    protected void method_11007(class_2487 compound, class_7225.class_7874 registries) {
        super.method_11007(compound, registries);
        if (this.schematic != null) {
            compound.method_10582("SchematicName", this.schematic.schema.getName());
        }
        compound.method_10566("Positions", (class_2520)NBTTags.nbtIntegerCollection(new ArrayList<Integer>(this.positions)));
        compound.method_10566("PositionsSecond", (class_2520)NBTTags.nbtIntegerCollection(new ArrayList<Integer>(this.positionsSecond)));
        this.writePartNBT(compound);
    }

    public void readPartNBT(class_2487 compound) {
        this.rotation = compound.method_10550("Rotation");
        this.yOffest = compound.method_10550("YOffset");
        this.enabled = compound.method_10577("Enabled");
        this.started = compound.method_10577("Started");
        this.finished = compound.method_10577("Finished");
        this.availability.load((class_7225.class_7874)this.field_11863.method_30349(), compound.method_10562("Availability"));
    }

    public class_2487 writePartNBT(class_2487 compound) {
        compound.method_10569("Rotation", this.rotation);
        compound.method_10569("YOffset", this.yOffest);
        compound.method_10556("Enabled", this.enabled);
        compound.method_10556("Started", this.started);
        compound.method_10556("Finished", this.finished);
        compound.method_10566("Availability", (class_2520)this.availability.save((class_7225.class_7874)this.field_11863.method_30349(), new class_2487()));
        return compound;
    }

    @Environment(value=EnvType.CLIENT)
    public void setDrawSchematic(SchematicWrapper schematics) {
        this.schematic = schematics;
    }

    public void setSchematic(SchematicWrapper schematics) {
        this.schematic = schematics;
        if (schematics == null) {
            this.positions.clear();
            this.positionsSecond.clear();
            return;
        }
        Stack<Integer> positions = new Stack<Integer>();
        for (int y = 0; y < schematics.schema.getHeight(); ++y) {
            int x;
            int z;
            for (z = 0; z < schematics.schema.getLength() / 2; ++z) {
                for (x = 0; x < schematics.schema.getWidth() / 2; ++x) {
                    positions.add(0, this.xyzToIndex(x, y, z));
                }
            }
            for (z = 0; z < schematics.schema.getLength() / 2; ++z) {
                for (x = schematics.schema.getWidth() / 2; x < schematics.schema.getWidth(); ++x) {
                    positions.add(0, this.xyzToIndex(x, y, z));
                }
            }
            for (z = schematics.schema.getLength() / 2; z < schematics.schema.getLength(); ++z) {
                for (x = 0; x < schematics.schema.getWidth() / 2; ++x) {
                    positions.add(0, this.xyzToIndex(x, y, z));
                }
            }
            for (z = schematics.schema.getLength() / 2; z < schematics.schema.getLength(); ++z) {
                for (x = schematics.schema.getWidth() / 2; x < schematics.schema.getWidth(); ++x) {
                    positions.add(0, this.xyzToIndex(x, y, z));
                }
            }
        }
        this.positions = positions;
        this.positionsSecond.clear();
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.schematic.schema.getLength() + z) * this.schematic.schema.getWidth() + x;
    }

    public SchematicWrapper getSchematic() {
        return this.schematic;
    }

    public boolean hasSchematic() {
        return this.schematic != null;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TileBuilder tile) {
        if (level.field_9236 || !tile.hasSchematic() || tile.finished) {
            return;
        }
        --tile.ticks;
        if (tile.ticks > 0) {
            return;
        }
        tile.ticks = 200;
        if (tile.positions.isEmpty() && tile.positionsSecond.isEmpty()) {
            tile.finished = true;
            return;
        }
        if (!tile.started) {
            for (class_1657 player : tile.getPlayerList()) {
                if (!tile.availability.isAvailable(player)) continue;
                tile.started = true;
                break;
            }
            if (!tile.started) {
                return;
            }
        }
        List list = level.method_18467(EntityNPCInterface.class, new class_238(pos.method_46558(), pos.method_46558()).method_1009(32.0, 32.0, 32.0));
        for (EntityNPCInterface npc : list) {
            if (npc.job.getType() != 10) continue;
            JobBuilder job = (JobBuilder)npc.job;
            if (job.build != null) continue;
            job.build = tile;
        }
    }

    private List<class_1657> getPlayerList() {
        return this.field_11863.method_18467(class_1657.class, new class_238((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (double)(this.field_11867.method_10263() + 1), (double)(this.field_11867.method_10264() + 1), (double)(this.field_11867.method_10260() + 1)).method_1009(10.0, 10.0, 10.0));
    }

    public Stack<BlockData> getBlock() {
        if (!this.enabled || this.finished || !this.hasSchematic()) {
            return null;
        }
        boolean bo = this.positions.isEmpty();
        Stack<BlockData> list = new Stack<BlockData>();
        int size = this.schematic.schema.getWidth() * this.schematic.schema.getLength() / 4;
        if (size > 30) {
            size = 30;
        }
        for (int i = 0; i < size; ++i) {
            if (this.positions.isEmpty() && !bo || this.positionsSecond.isEmpty() && bo) {
                return list;
            }
            int pos = bo ? this.positionsSecond.pop() : this.positions.pop();
            if (pos >= this.schematic.size) continue;
            int x = pos % this.schematic.schema.getWidth();
            int z = (pos - x) / this.schematic.schema.getWidth() % this.schematic.schema.getLength();
            int y = ((pos - x) / this.schematic.schema.getWidth() - z) / this.schematic.schema.getLength();
            class_2680 state = this.schematic.schema.getBlockState(x, y, z);
            if (!state.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980) && !bo && state.method_26204() != class_2246.field_10124) {
                this.positionsSecond.add(0, pos);
                continue;
            }
            class_2338 blockPos = this.method_11016().method_10069(1, this.yOffest, 1).method_10081((class_2382)this.schematic.rotatePos(x, y, z, this.rotation));
            class_2680 original = this.field_11863.method_8320(blockPos);
            if (class_2248.method_9507((class_2680)state) == class_2248.method_9507((class_2680)original)) continue;
            state = this.schematic.rotationState(state, this.rotation);
            class_2487 tile = null;
            if (state.method_26204() instanceof class_2343) {
                tile = this.schematic.getBlockEntity(x, y, z, blockPos);
            }
            list.add(0, new BlockData(blockPos, state, tile));
        }
        return list;
    }

    public static void SetDrawPos(class_2338 pos) {
        DrawPos = pos;
        Compiled = false;
    }
}

